"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.HTTP_VERBS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _steps = require("./steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/webhook_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HTTP_VERBS = exports.HTTP_VERBS = ['post', 'put', 'patch', 'get'];
const fields = {
  step1: ['config.hasAuth', 'secrets.user', 'secrets.password', '__internal__.hasHeaders', 'config.headers'],
  step2: ['config.createIncidentMethod', 'config.createIncidentUrl', 'config.createIncidentJson', 'config.createIncidentResponseKey'],
  step3: ['config.getIncidentMethod', 'config.getIncidentUrl', 'config.getIncidentJson', 'config.getIncidentResponseExternalTitleKey', 'config.viewIncidentUrl'],
  step4: ['config.updateIncidentMethod', 'config.updateIncidentUrl', 'config.updateIncidentJson', 'config.createCommentMethod', 'config.createCommentUrl', 'config.createCommentJson']
};
const CasesWebhookActionConnectorFields = ({
  readOnly
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const {
    isValid,
    getFields,
    validateFields
  } = (0, _hook_form_lib.useFormContext)();
  const [currentStep, setCurrentStep] = (0, _react.useState)(1);
  const [status, setStatus] = (0, _react.useState)({
    step1: 'incomplete',
    step2: 'incomplete',
    step3: 'incomplete',
    step4: 'incomplete'
  });
  const updateStatus = (0, _react.useCallback)(async () => {
    const steps = [1, 2, 3, 4];
    const currentFields = getFields();
    const statuses = steps.map(index => {
      if (typeof isValid !== 'undefined' && !isValid) {
        const fieldsToValidate = fields[`step${index}`];
        // submit validation fields have already been through validator
        // so we can look at the isValid property from `getFields()`
        const areFieldsValid = fieldsToValidate.every(field => currentFields[field] !== undefined ? currentFields[field].isValid : true);
        return {
          [`step${index}`]: areFieldsValid ? 'complete' : 'danger'
        };
      }
      return {
        [`step${index}`]: currentStep === index ? 'current' : currentStep > index ? 'complete' : 'incomplete'
      };
    });
    setStatus(statuses.reduce((acc, i) => ({
      ...acc,
      ...i
    }), {}));
  }, [currentStep, getFields, isValid]);
  (0, _react.useEffect)(() => {
    updateStatus();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isValid, currentStep]);
  const getNextStep = (selectedStep, step) => {
    if (selectedStep) return selectedStep;
    return step === 4 ? step : step + 1;
  };
  const getFieldsToValidate = (0, _react.useCallback)((nextStep, step) => {
    const currentFields = getFields();
    const headerFields = Object.keys(currentFields).filter(field => field.startsWith('__internal__.headers'));
    if (step === 1) {
      headerFields.forEach(field => {
        if (!fields.step1.includes(field)) {
          fields.step1.push(field);
        }
      });
    }
    const fieldsToValidate = nextStep === 2 ? fields.step1 : nextStep === 3 ? [...fields.step1, ...fields.step2] : nextStep === 4 ? [...fields.step1, ...fields.step2, ...fields.step3] : [];
    return fieldsToValidate;
  }, [getFields]);
  const onNextStep = (0, _react.useCallback)(async selectedStep => {
    const nextStep = getNextStep(selectedStep, currentStep);
    const fieldsToValidate = getFieldsToValidate(nextStep, currentStep);

    // step validation needs async call in order to run each field through validator
    const {
      areFieldsValid
    } = await validateFields(fieldsToValidate);
    if (!areFieldsValid) {
      setStatus(currentStatus => ({
        ...currentStatus,
        [`step${currentStep}`]: 'danger'
      }));
      return;
    }
    if (nextStep < 5) {
      setCurrentStep(nextStep);
    }
  }, [currentStep, getFieldsToValidate, validateFields]);
  const horizontalSteps = (0, _react.useMemo)(() => [{
    title: i18n.STEP_1,
    status: status.step1,
    onClick: () => setCurrentStep(1),
    ['data-test-subj']: `horizontalStep1-${status.step1}`
  }, {
    title: i18n.STEP_2,
    status: status.step2,
    onClick: () => onNextStep(2),
    ['data-test-subj']: `horizontalStep2-${status.step2}`
  }, {
    title: i18n.STEP_3,
    status: status.step3,
    onClick: () => onNextStep(3),
    ['data-test-subj']: `horizontalStep3-${status.step3}`
  }, {
    title: i18n.STEP_4,
    status: status.step4,
    onClick: () => onNextStep(4),
    ['data-test-subj']: `horizontalStep4-${status.step4}`
  }], [onNextStep, status]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: horizontalSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/kibana/${docLinks.DOC_LINK_VERSION}/cases-webhook-action-type.html`,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, i18n.DOC_LINK), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.AuthStep, {
    readOnly: readOnly,
    display: currentStep === 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.CreateStep, {
    readOnly: readOnly,
    display: currentStep === 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.GetStep, {
    readOnly: readOnly,
    display: currentStep === 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_steps.UpdateStep, {
    readOnly: readOnly,
    display: currentStep === 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexStart",
    direction: "rowReverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, currentStep < 4 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 160
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "casesWebhookNext",
    fill: true,
    iconSide: "right",
    iconType: "arrowRight",
    onClick: () => onNextStep(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }, i18n.NEXT)), currentStep > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 160
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "casesWebhookBack",
    iconSide: "left",
    iconType: "arrowLeft",
    onClick: () => onNextStep(currentStep - 1),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }, i18n.PREVIOUS))));
};

// eslint-disable-next-line import/no-default-export
exports.default = CasesWebhookActionConnectorFields;