"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCreateComment = exports.requiredJsonForPost = exports.isUrlButCanBeEmpty = exports.containsTitleAndDesc = exports.containsExternalIdOrTitle = exports.containsExternalIdForGet = exports.containsCommentsOrEmpty = void 0;
var _lodash = require("lodash");
var _string = require("@kbn/es-ui-shared-plugin/static/validators/string");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("@kbn/connector-schemas/common/auth/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _action_variables = require("./action_variables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCode = 'ERR_FIELD_MISSING';
const missingVariableErrorMessage = (path, variables) => ({
  code: errorCode,
  path,
  message: i18n.MISSING_VARIABLES(variables)
});
const containsTitleAndDesc = () => (...args) => {
  const [{
    value,
    path
  }] = args;
  const title = (0, _public.templateActionVariable)(_action_variables.casesVars.find(actionVariable => actionVariable.name === 'case.title'));
  const description = (0, _public.templateActionVariable)(_action_variables.casesVars.find(actionVariable => actionVariable.name === 'case.description'));
  const varsWithErrors = [title, description].filter(variable => !(0, _string.containsChars)(variable)(value).doesContain);
  if (varsWithErrors.length > 0) {
    return missingVariableErrorMessage(path, varsWithErrors);
  }
};
exports.containsTitleAndDesc = containsTitleAndDesc;
const containsExternalIdForGet = method => (...args) => {
  const [{
    value,
    path
  }] = args;
  const id = (0, _public.templateActionVariable)(_action_variables.urlVars.find(actionVariable => actionVariable.name === 'external.system.id'));
  return method === _constants.WebhookMethods.GET && value !== null && !(0, _string.containsChars)(id)(value).doesContain ? missingVariableErrorMessage(path, [id]) : undefined;
};
exports.containsExternalIdForGet = containsExternalIdForGet;
const containsExternalIdOrTitle = () => (...args) => {
  const [{
    value,
    path
  }] = args;
  const id = (0, _public.templateActionVariable)(_action_variables.urlVars.find(actionVariable => actionVariable.name === 'external.system.id'));
  const title = (0, _public.templateActionVariable)(_action_variables.urlVarsExt.find(actionVariable => actionVariable.name === 'external.system.title'));
  const error = missingVariableErrorMessage(path, [id, title]);
  if (typeof value === 'string') {
    const {
      doesContain: doesContainId
    } = (0, _string.containsChars)(id)(value);
    const {
      doesContain: doesContainTitle
    } = (0, _string.containsChars)(title)(value);
    if (doesContainId || doesContainTitle) {
      return undefined;
    }
  }
  return error;
};
exports.containsExternalIdOrTitle = containsExternalIdOrTitle;
const requiredJsonForPost = method => (...args) => {
  const [{
    value,
    path
  }] = args;
  const error = {
    code: errorCode,
    path,
    message: i18n.GET_INCIDENT_REQUIRED
  };
  return method === _constants.WebhookMethods.POST && (value === null || (0, _lodash.isEmpty)(value)) ? error : undefined;
};
exports.requiredJsonForPost = requiredJsonForPost;
const containsCommentsOrEmpty = message => (...args) => {
  const [{
    value,
    path
  }] = args;
  if (value === null || value === undefined || value === '') {
    return undefined;
  }
  if (typeof value !== 'string') {
    return {
      code: 'ERR_FIELD_FORMAT',
      formatType: 'STRING',
      message
    };
  }
  const comment = (0, _public.templateActionVariable)(_action_variables.commentVars.find(actionVariable => actionVariable.name === 'case.comment'));
  let error;
  if (typeof value === 'string') {
    const {
      doesContain
    } = (0, _string.containsChars)(comment)(value);
    if (!doesContain) {
      error = missingVariableErrorMessage(path, [comment]);
    }
  }
  return error;
};
exports.containsCommentsOrEmpty = containsCommentsOrEmpty;
const isUrlButCanBeEmpty = message => (...args) => {
  const [{
    value
  }] = args;
  const error = {
    code: 'ERR_FIELD_FORMAT',
    formatType: 'URL',
    message
  };
  if (value === null || value === undefined || value === '') {
    return undefined;
  }
  return typeof value === 'string' && (0, _string.isUrl)(value) ? undefined : error;
};
exports.isUrlButCanBeEmpty = isUrlButCanBeEmpty;
const validateCreateComment = (message, fieldName) => (...args) => {
  const [{
    value,
    formData
  }] = args;
  const otherFielValue = formData[fieldName];
  const error = {
    code: 'ERR_FIELD_FORMAT',
    formatType: 'STRING',
    message
  };
  return !value && otherFielValue ? error : undefined;
};
exports.validateCreateComment = validateCreateComment;