"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERIFICATION_MODE_LABEL = exports.VALUE_LABEL = exports.USERNAME_REQUIRED = exports.USERNAME = exports.SECRET_OPTION = exports.SCOPE_HELP_TEXT = exports.SCOPE = exports.SAME_HEADER_KEY_ERROR = exports.PFX_REQUIRED = exports.PASSWORD_REQUIRED = exports.PASSWORD = exports.OPTIONAL_LABEL = exports.MAX_HEADERS_LIMIT = exports.KEY_REQUIRED = exports.KEY_LABEL = exports.INVALID_JSON = exports.INVALID_INPUT_EMPTY = exports.INVALID_INPUT_ARRAY = exports.HEADER_TYPE_LABEL = exports.HEADER_MISSING_VALUE_ERROR = exports.HEADER_MISSING_KEY_ERROR = exports.HEADERS_TITLE = exports.HEADERS_SWITCH = exports.HEADERS_SUBTITLE = exports.ENCRYPTED_HEADERS_TOOLTIP_CONTENT = exports.ENCRYPTED_HEADERS_BADGE = exports.EDIT_CA_CALLOUT = exports.DELETE_BUTTON = exports.CRT_REQUIRED = exports.CONFIG_OPTION = exports.CLIENT_SECRET_REQUIRED = exports.CLIENT_SECRET = exports.CLIENT_ID_REQUIRED = exports.CLIENT_ID = exports.CERT_TYPE_PFX = exports.CERT_TYPE_CRT_KEY = exports.CA_REQUIRED = exports.AUTHENTICATION_TITLE = exports.AUTHENTICATION_SSL = exports.AUTHENTICATION_OAUTH2 = exports.AUTHENTICATION_NONE = exports.AUTHENTICATION_BASIC = exports.ADD_CA_LABEL = exports.ADD_BUTTON = exports.ADDITIONAL_FIELDS_HELP_WEBHOOK_TEXT = exports.ADDITIONAL_FIELDS = exports.ACCESS_TOKEN_URL_REQUIRED = exports.ACCESS_TOKEN_URL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTHENTICATION_TITLE = exports.AUTHENTICATION_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationTitle', {
  defaultMessage: 'Authentication'
});
const AUTHENTICATION_NONE = exports.AUTHENTICATION_NONE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodNoneLabel', {
  defaultMessage: 'None'
});
const AUTHENTICATION_BASIC = exports.AUTHENTICATION_BASIC = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodBasicLabel', {
  defaultMessage: 'Basic authentication'
});
const AUTHENTICATION_SSL = exports.AUTHENTICATION_SSL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodSSLLabel', {
  defaultMessage: 'SSL authentication'
});
const USERNAME = exports.USERNAME = _i18n.i18n.translate('xpack.stackConnectors.components.auth.userTextFieldLabel', {
  defaultMessage: 'Username'
});
const PASSWORD = exports.PASSWORD = _i18n.i18n.translate('xpack.stackConnectors.components.auth.passwordTextFieldLabel', {
  defaultMessage: 'Password'
});
const USERNAME_REQUIRED = exports.USERNAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredAuthUserNameText', {
  defaultMessage: 'Username is required.'
});
const PASSWORD_REQUIRED = exports.PASSWORD_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredAuthPasswordText', {
  defaultMessage: 'Password is required.'
});
const CERT_TYPE_CRT_KEY = exports.CERT_TYPE_CRT_KEY = _i18n.i18n.translate('xpack.stackConnectors.components.auth.certTypeCrtKeyLabel', {
  defaultMessage: 'CRT and KEY file'
});
const CERT_TYPE_PFX = exports.CERT_TYPE_PFX = _i18n.i18n.translate('xpack.stackConnectors.components.auth.certTypePfxLabel', {
  defaultMessage: 'PFX file'
});
const CRT_REQUIRED = exports.CRT_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredCRTText', {
  defaultMessage: 'CRT file is required.'
});
const KEY_REQUIRED = exports.KEY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredKEYText', {
  defaultMessage: 'KEY file is required.'
});
const PFX_REQUIRED = exports.PFX_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredPFXText', {
  defaultMessage: 'PFX file is required.'
});
const HEADERS_SWITCH = exports.HEADERS_SWITCH = _i18n.i18n.translate('xpack.stackConnectors.components.auth.viewHeadersSwitch', {
  defaultMessage: 'Add HTTP header'
});
const HEADERS_TITLE = exports.HEADERS_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.httpHeadersTitle', {
  defaultMessage: 'HTTP headers'
});
const HEADERS_SUBTITLE = exports.HEADERS_SUBTITLE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.httpHeadersSubtitle', {
  defaultMessage: 'Add custom HTTP headers to be sent with API requests'
});
const MAX_HEADERS_LIMIT = maxHeaders => _i18n.i18n.translate('xpack.stackConnectors.components.auth.maxHeaders', {
  values: {
    maxHeaders
  },
  defaultMessage: 'Maximum number of {maxHeaders} headers reached.'
});
exports.MAX_HEADERS_LIMIT = MAX_HEADERS_LIMIT;
const KEY_LABEL = exports.KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.keyTextFieldLabel', {
  defaultMessage: 'Key'
});
const ENCRYPTED_HEADERS_BADGE = exports.ENCRYPTED_HEADERS_BADGE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.encryptedHeadersBadge', {
  defaultMessage: 'Encrypted Headers'
});
const ENCRYPTED_HEADERS_TOOLTIP_CONTENT = exports.ENCRYPTED_HEADERS_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.stackConnectors.components.auth.encryptedHeadersTooltipContent', {
  defaultMessage: 'Values of the secret headers are encrypted. You must re-enter them when editing the connector'
});
const SAME_HEADER_KEY_ERROR = exports.SAME_HEADER_KEY_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.auth.sameHeaderKeyError', {
  defaultMessage: 'This key is already used in another header'
});
const VALUE_LABEL = exports.VALUE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.valueTextFieldLabel', {
  defaultMessage: 'Value'
});
const CONFIG_OPTION = exports.CONFIG_OPTION = _i18n.i18n.translate('xpack.stackConnectors.components.auth.configHeaderLabel', {
  defaultMessage: 'Config'
});
const HEADER_TYPE_LABEL = exports.HEADER_TYPE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.headerTypeLabel', {
  defaultMessage: 'Type'
});
const SECRET_OPTION = exports.SECRET_OPTION = _i18n.i18n.translate('xpack.stackConnectors.components.auth.secretHeaderLabel', {
  defaultMessage: 'Secret'
});
const HEADER_MISSING_VALUE_ERROR = exports.HEADER_MISSING_VALUE_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.auth.secretHeaderMissingValueError', {
  defaultMessage: 'Value is required'
});
const HEADER_MISSING_KEY_ERROR = exports.HEADER_MISSING_KEY_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.auth.secretHeaderMissingValueError', {
  defaultMessage: 'Key is required'
});
const ADD_BUTTON = exports.ADD_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.auth.addHeaderButton', {
  defaultMessage: 'Add header'
});
const DELETE_BUTTON = exports.DELETE_BUTTON = _i18n.i18n.translate('xpack.stackConnectors.components.auth.deleteHeaderButton', {
  defaultMessage: 'Delete',
  description: 'Delete HTTP header'
});
const CA_REQUIRED = exports.CA_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredCAText', {
  defaultMessage: 'CA file is required.'
});
const ADD_CA_LABEL = exports.ADD_CA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.viewCertificateAuthoritySwitch', {
  defaultMessage: 'Add certificate authority'
});
const VERIFICATION_MODE_LABEL = exports.VERIFICATION_MODE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.verificationModeFieldLabel', {
  defaultMessage: 'Verification mode'
});
const EDIT_CA_CALLOUT = exports.EDIT_CA_CALLOUT = _i18n.i18n.translate('xpack.stackConnectors.components.auth.editCACallout', {
  defaultMessage: 'This connector has an existing certificate authority file. Upload a new one to replace it.'
});
const ACCESS_TOKEN_URL = exports.ACCESS_TOKEN_URL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.accessTokenUrlTextFieldLabel', {
  defaultMessage: 'Access token URL',
  description: 'The URL to get the access token from'
});
const ACCESS_TOKEN_URL_REQUIRED = exports.ACCESS_TOKEN_URL_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredAccessTokenUrlText', {
  defaultMessage: 'Access token URL is required.'
});
const CLIENT_ID = exports.CLIENT_ID = _i18n.i18n.translate('xpack.stackConnectors.components.auth.clientIdTextFieldLabel', {
  defaultMessage: 'Client ID',
  description: 'The client ID to use for OAuth2 authentication'
});
const CLIENT_ID_REQUIRED = exports.CLIENT_ID_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredClientIdText', {
  defaultMessage: 'Client ID is required.'
});
const CLIENT_SECRET = exports.CLIENT_SECRET = _i18n.i18n.translate('xpack.stackConnectors.components.auth.clientSecretTextFieldLabel', {
  defaultMessage: 'Client secret',
  description: 'The client secret to use for for OAuth2 authentication'
});
const CLIENT_SECRET_REQUIRED = exports.CLIENT_SECRET_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.auth.error.requiredClientSecretText', {
  defaultMessage: 'Client secret is required.'
});
const SCOPE = exports.SCOPE = _i18n.i18n.translate('xpack.stackConnectors.components.auth.clientSecretTextFieldLabel', {
  defaultMessage: 'Scope',
  description: 'The scope to use for for OAuth2 authentication'
});
const SCOPE_HELP_TEXT = exports.SCOPE_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.auth.scopeHelpText', {
  defaultMessage: "Space-separated list of scopes (e.g., 'email profile')."
});
const AUTHENTICATION_OAUTH2 = exports.AUTHENTICATION_OAUTH2 = _i18n.i18n.translate('xpack.stackConnectors.components.auth.authenticationMethodOAuth2Label', {
  defaultMessage: 'OAuth 2.0 Client Credentials'
});
const INVALID_JSON = exports.INVALID_JSON = _i18n.i18n.translate('xpack.stackConnectors.components.additionalFieldsFormatErrorMessage', {
  defaultMessage: 'Invalid JSON'
});
const INVALID_INPUT_EMPTY = exports.INVALID_INPUT_EMPTY = _i18n.i18n.translate('xpack.stackConnectors.components.additionalFieldsEmptyErrorMessage', {
  defaultMessage: 'Invalid JSON, cannot be empty'
});
const INVALID_INPUT_ARRAY = exports.INVALID_INPUT_ARRAY = _i18n.i18n.translate('xpack.stackConnectors.components.additionalFieldsArrayErrorMessage', {
  defaultMessage: 'Invalid JSON, cannot be an array'
});
const ADDITIONAL_FIELDS = exports.ADDITIONAL_FIELDS = _i18n.i18n.translate('xpack.stackConnectors.components.additionalFieldsTitle', {
  defaultMessage: 'Additional fields',
  description: 'Title for the additional fields section'
});
const ADDITIONAL_FIELDS_HELP_WEBHOOK_TEXT = exports.ADDITIONAL_FIELDS_HELP_WEBHOOK_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.webhhok.additionalFieldsHelpTooltipText', {
  defaultMessage: 'Additional fields in JSON format. Your token provider may require more that just the default fields.'
});
const OPTIONAL_LABEL = exports.OPTIONAL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.auth.optionalLabel', {
  defaultMessage: 'Optional'
});