"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AuthConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _lodash = require("lodash");
var _constants = require("@kbn/connector-schemas/common/auth/constants");
var _use_secret_headers = require("./use_secret_headers");
var _ssl_cert_fields = require("./ssl_cert_fields");
var _basic_auth_fields = require("./basic_auth_fields");
var _header_fields = require("./header_fields");
var _oauth2_fields = require("./oauth2_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/common/auth/auth_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const VERIFICATION_MODE_DEFAULT = 'full';
const AuthConfig = ({
  readOnly,
  isPfxEnabled = true,
  isOAuth2Enabled = false
}) => {
  var _getFieldDefaultValue, _getFieldDefaultValue2;
  const isModified = (0, _hook_form_lib.useFormIsModified)();
  const {
    setFieldValue,
    getFieldDefaultValue,
    getFormData,
    updateFieldValues
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__,
    id: connectorId
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.hasAuth', 'config.authType', 'config.certType', 'config.verificationMode', '__internal__.hasHeaders', '__internal__.hasCA', '__internal__.headers']
  });
  const {
    data: secretHeaderKeys = [],
    isLoading: isLoadingHeaders,
    isFetching: isFetchingHeaders
  } = (0, _use_secret_headers.useSecretHeaders)(connectorId);
  const loadingHeaders = isLoadingHeaders || isFetchingHeaders;
  const authType = config == null ? _constants.AuthType.Basic : config.authType;
  const certType = config == null ? _constants.SSLCertType.CRT : config.certType;
  const hasHeaders = __internal__ != null ? __internal__.hasHeaders : false;
  const hasCA = __internal__ != null ? __internal__.hasCA : false;

  // Default Values
  const hasInitialCA = !!getFieldDefaultValue('config.ca');
  const hasHeadersDefaultValue = !!getFieldDefaultValue('config.headers');
  const authTypeDefaultValue = getFieldDefaultValue('config.hasAuth') === false ? null : (_getFieldDefaultValue = getFieldDefaultValue('config.authType')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : _constants.AuthType.Basic;
  const certTypeDefaultValue = (_getFieldDefaultValue2 = getFieldDefaultValue('config.certType')) !== null && _getFieldDefaultValue2 !== void 0 ? _getFieldDefaultValue2 : _constants.SSLCertType.CRT;
  const hasCADefaultValue = !!getFieldDefaultValue('config.ca') || getFieldDefaultValue('config.verificationMode') === 'none';
  (0, _react.useEffect)(() => setFieldValue('config.hasAuth', Boolean(authType)), [authType, setFieldValue]);
  (0, _react.useEffect)(() => {
    var _formData$__internal_, _formData$__internal_2;
    if (loadingHeaders) return;
    const formData = getFormData();
    const secretHeaderKeysSet = new Set(secretHeaderKeys);
    const currentHeaders = ((_formData$__internal_ = (_formData$__internal_2 = formData.__internal__) === null || _formData$__internal_2 === void 0 ? void 0 : _formData$__internal_2.headers) !== null && _formData$__internal_ !== void 0 ? _formData$__internal_ : []).map(header => {
      if (secretHeaderKeysSet.has(header.key)) {
        return {
          ...header,
          value: '',
          type: 'secret'
        };
      }
      return header;
    });
    const currentHeadersKeysSet = new Set(currentHeaders.map(header => header.key));
    const newSecretHeaders = secretHeaderKeys.filter(key => !currentHeadersKeysSet.has(key)).map(key => ({
      key,
      value: '',
      type: 'secret'
    }));
    let mergedHeaders = [...currentHeaders, ...newSecretHeaders];
    if (mergedHeaders.length === 0 && hasHeaders) {
      mergedHeaders = [{
        key: '',
        value: '',
        type: 'config'
      }];
    }
    if (!(0, _lodash.isEqual)(currentHeaders, mergedHeaders)) {
      updateFieldValues({
        __internal__: {
          ...formData.__internal__,
          /*
           * If the user modifies the form, whatever is returned from useSecretHeaders
           * might not be up to date.
           *
           * Has headers can only be uptaded on first render or after the form is submitted.
           * */
          ...(!isModified && {
            hasHeaders: mergedHeaders.length > 0
          }),
          headers: mergedHeaders
        }
      });
    }
  }, [connectorId, getFormData, secretHeaderKeys, updateFieldValues, hasHeaders, loadingHeaders, isModified]);
  const options = [{
    value: null,
    label: i18n.AUTHENTICATION_NONE,
    'data-test-subj': 'authNone'
  }, {
    value: _constants.AuthType.Basic,
    label: i18n.AUTHENTICATION_BASIC,
    children: authType === _constants.AuthType.Basic && /*#__PURE__*/_react.default.createElement(_basic_auth_fields.BasicAuthFields, {
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 48
      }
    }),
    'data-test-subj': 'authBasic'
  }, {
    value: _constants.AuthType.SSL,
    label: i18n.AUTHENTICATION_SSL,
    children: authType === _constants.AuthType.SSL && /*#__PURE__*/_react.default.createElement(_ssl_cert_fields.SSLCertFields, {
      readOnly: readOnly,
      certTypeDefaultValue: certTypeDefaultValue,
      certType: certType,
      isPfxEnabled: isPfxEnabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'authSSL'
  }, (isOAuth2Enabled || authType === _constants.AuthType.OAuth2ClientCredentials) && {
    value: _constants.AuthType.OAuth2ClientCredentials,
    label: i18n.AUTHENTICATION_OAUTH2,
    children: authType === _constants.AuthType.OAuth2ClientCredentials && /*#__PURE__*/_react.default.createElement(_oauth2_fields.OAuth2Fields, {
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'authOAuth2'
  }].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, i18n.AUTHENTICATION_TITLE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.hasAuth",
    component: _components.HiddenField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.authType",
    defaultValue: authTypeDefaultValue,
    component: _components.CardRadioGroupField,
    componentProps: {
      options
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField
  /*
   * This has to be "hidden". Not rendering when loading headers
   * was affecting the form value when submitting
   * */, {
    style: {
      visibility: loadingHeaders ? 'hidden' : 'visible'
    },
    path: "__internal__.hasHeaders",
    component: _components.ToggleField,
    config: {
      defaultValue: hasHeadersDefaultValue,
      label: i18n.HEADERS_SWITCH
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'webhookViewHeadersSwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }), loadingHeaders ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasHeaders && /*#__PURE__*/_react.default.createElement(_header_fields.HeaderFields, {
    maxHeaders: _constants.MAX_HEADERS,
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 26
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasCA",
    component: _components.ToggleField,
    config: {
      defaultValue: hasCADefaultValue,
      label: i18n.ADD_CA_LABEL
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'webhookViewCASwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }), hasCA && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.ca",
    config: {
      label: 'CA file',
      validations: [{
        validator: (config === null || config === void 0 ? void 0 : config.verificationMode) !== 'none' ? emptyField(i18n.CA_REQUIRED) : () => {}
      }]
    },
    component: _components.FilePickerField,
    componentProps: {
      euiFieldProps: {
        display: 'default',
        'data-test-subj': 'webhookCAInput',
        accept: '.ca,.pem'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.verificationMode",
    component: _components.SelectField,
    config: {
      label: i18n.VERIFICATION_MODE_LABEL,
      defaultValue: VERIFICATION_MODE_DEFAULT,
      validations: [{
        validator: emptyField(i18n.VERIFICATION_MODE_LABEL)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'webhookVerificationModeSelect',
        options: [{
          text: 'None',
          value: 'none'
        }, {
          text: 'Certificate',
          value: 'certificate'
        }, {
          text: 'Full',
          value: 'full'
        }],
        fullWidth: true,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  }))), hasInitialCA && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    size: "s",
    iconType: "document",
    title: i18n.EDIT_CA_CALLOUT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.AuthConfig = AuthConfig;
var _default = exports.default = AuthConfig;