"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateConnectorAuthConfiguration = exports.isBasicAuth = exports.buildConnectorAuth = void 0;
var _lodash = require("lodash");
var _constants = require("@kbn/connector-schemas/common/auth/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// For backwards compatibility with connectors created before authType was added, interpret a
// hasAuth: true and undefined authType as basic auth
const isBasicAuth = ({
  hasAuth,
  authType
}) => hasAuth && (authType === _constants.AuthType.Basic || !authType);
exports.isBasicAuth = isBasicAuth;
const buildConnectorAuth = ({
  hasAuth,
  authType,
  secrets,
  verificationMode,
  ca
}) => {
  let basicAuth = {};
  let sslOverrides = {};
  let sslCertificate = {};
  if (isBasicAuth({
    hasAuth,
    authType
  })) {
    basicAuth = (0, _lodash.isString)(secrets.user) && (0, _lodash.isString)(secrets.password) ? {
      auth: {
        username: secrets.user,
        password: secrets.password
      }
    } : {};
  } else if (hasAuth && authType === _constants.AuthType.SSL) {
    sslCertificate = (0, _lodash.isString)(secrets.crt) && (0, _lodash.isString)(secrets.key) || (0, _lodash.isString)(secrets.pfx) ? (0, _lodash.isString)(secrets.pfx) ? {
      pfx: Buffer.from(secrets.pfx, 'base64'),
      ...((0, _lodash.isString)(secrets.password) ? {
        passphrase: secrets.password
      } : {})
    } : {
      cert: Buffer.from(secrets.crt, 'base64'),
      key: Buffer.from(secrets.key, 'base64'),
      ...((0, _lodash.isString)(secrets.password) ? {
        passphrase: secrets.password
      } : {})
    } : {};
  }
  sslOverrides = {
    ...sslCertificate,
    ...(verificationMode ? {
      verificationMode
    } : {}),
    ...(ca ? {
      ca: Buffer.from(ca, 'base64')
    } : {})
  };
  return {
    basicAuth,
    sslOverrides
  };
};
exports.buildConnectorAuth = buildConnectorAuth;
const validateConnectorAuthConfiguration = ({
  hasAuth,
  authType,
  basicAuth,
  sslOverrides,
  connectorName
}) => {
  var _basicAuth$auth, _basicAuth$auth2;
  if (isBasicAuth({
    hasAuth,
    authType
  }) && (!((_basicAuth$auth = basicAuth.auth) !== null && _basicAuth$auth !== void 0 && _basicAuth$auth.password) || !((_basicAuth$auth2 = basicAuth.auth) !== null && _basicAuth$auth2 !== void 0 && _basicAuth$auth2.username)) || authType === _constants.AuthType.SSL && (0, _lodash.isEmpty)(sslOverrides)) {
    throw Error(`[Action]${connectorName}: Wrong configuration.`);
  }
};
exports.validateConnectorAuthConfiguration = validateConnectorAuthConfiguration;