"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleCommonExpressions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/triggers-actions-ui-plugin/public/common");
var _constants = require("../constants");
var _test_query_row = require("../test_query_row");
var _threshold_help_popover = require("./threshold_help_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/rule_common_expressions/rule_common_expressions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SIZE_VALUE_TOOLTIP_CONTENT = _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectSizePrompt.toolTip', {
  defaultMessage: 'Specify the number of documents to pass to the configured actions when the threshold condition is met.'
});
const SIZE_VALUE_EXPRESSION_LABEL = _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.selectSizePrompt.label', {
  defaultMessage: 'Set the number of documents to send.'
});
const RuleCommonExpressions = ({
  esFields,
  thresholdComparator,
  threshold,
  timeWindowSize,
  timeWindowUnit,
  aggType,
  aggField,
  groupBy,
  termField,
  termSize,
  size,
  errors,
  hasValidationErrors,
  onChangeSelectedAggField,
  onChangeSelectedAggType,
  onChangeSelectedGroupBy,
  onChangeSelectedTermField,
  onChangeSelectedTermSize,
  onChangeThreshold,
  onChangeThresholdComparator,
  onChangeWindowSize,
  onChangeWindowUnit,
  onChangeSizeValue,
  onTestFetch,
  onCopyQuery,
  excludeHitsFromPreviousRun,
  onChangeExcludeHitsFromPreviousRun,
  canSelectMultiTerms
}) => {
  const [isExcludeHitsDisabled, setIsExcludeHitsDisabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (groupBy) {
      setIsExcludeHitsDisabled(groupBy !== _common.builtInGroupByTypes.all.value);
    }
  }, [groupBy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.conditionsPrompt",
      defaultMessage: "Set the group, threshold, and time window",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_threshold_help_popover.QueryThresholdHelpPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.WhenExpression, {
    display: "fullWidth",
    "data-test-subj": "whenExpression",
    aggType: aggType !== null && aggType !== void 0 ? aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    onChangeSelectedAggType: onChangeSelectedAggType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  })), aggType && _public.builtInAggregationTypes[aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_public.OfExpression, {
    aggField: aggField,
    "data-test-subj": "aggTypeExpression",
    fields: esFields,
    aggType: aggType,
    errors: errors,
    display: "fullWidth",
    onChangeSelectedAggField: onChangeSelectedAggField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_public.GroupByExpression, {
    groupBy: groupBy || _constants.DEFAULT_VALUES.GROUP_BY,
    "data-test-subj": "groupByExpression",
    termField: termField,
    termSize: termSize,
    errors: errors,
    fields: esFields,
    display: "fullWidth",
    canSelectMultiTerms: canSelectMultiTerms,
    onChangeSelectedGroupBy: onChangeSelectedGroupBy,
    onChangeSelectedTermField: onChangeSelectedTermField,
    onChangeSelectedTermSize: onChangeSelectedTermSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ThresholdExpression, {
    "data-test-subj": "thresholdExpression",
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    threshold: threshold !== null && threshold !== void 0 ? threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    errors: errors,
    display: "fullWidth",
    popupPosition: "upLeft",
    onChangeSelectedThreshold: onChangeThreshold,
    onChangeSelectedThresholdComparator: onChangeThresholdComparator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ForLastExpression, {
    "data-test-subj": "forLastExpression",
    popupPosition: "upLeft",
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    display: "fullWidth",
    errors: errors,
    onChangeWindowSize: onChangeWindowSize,
    onChangeWindowUnit: onChangeWindowUnit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "sizeValueExpression",
    label: [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectSizePrompt",
      defaultMessage: "Set the number of documents to send",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      color: "subdued",
      type: "question",
      content: SIZE_VALUE_TOOLTIP_CONTENT,
      "aria-label": SIZE_VALUE_EXPRESSION_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
    description: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.sizeExpression', {
      defaultMessage: 'Size'
    }),
    value: size,
    errors: errors.size,
    display: "fullWidth",
    popupPosition: "upLeft",
    onChangeSelectedValue: onChangeSizeValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    disabled: isExcludeHitsDisabled,
    "data-test-subj": "excludeHitsFromPreviousRunExpression",
    checked: excludeHitsFromPreviousRun,
    id: "excludeHitsFromPreviousRunExpressionId",
    onChange: event => {
      onChangeExcludeHitsFromPreviousRun(event.target.checked);
    },
    label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.excludePreviousHitsExpression', {
      defaultMessage: 'Exclude matches from previous runs'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_test_query_row.TestQueryRow, {
    fetch: onTestFetch,
    copyQuery: onCopyQuery,
    hasValidationErrors: hasValidationErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }));
};
exports.RuleCommonExpressions = RuleCommonExpressions;