"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionFields = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDescriptionFields = ({
  rule,
  prebuildFields
}) => {
  if (!rule || !prebuildFields) return [];
  if (rule.params.searchType === 'esQuery') {
    const params = rule.params;
    return [prebuildFields.indexPattern(params.index), prebuildFields.customQuery(params.esQuery)];
  }
  if (rule.params.searchType === 'esqlQuery') {
    const params = rule.params;
    return [prebuildFields.esqlQuery(params.esqlQuery.esql)];
  }
  if (rule.params.searchType === 'searchSource' && rule.params.searchConfiguration) {
    const params = rule.params;
    const searchConfig = params.searchConfiguration;
    const fields = [];
    if (searchConfig !== null && searchConfig !== void 0 && searchConfig.index && typeof searchConfig.index === 'string') {
      fields.push(prebuildFields.dataViewIndexPattern(searchConfig.index));
    }
    if (searchConfig !== null && searchConfig !== void 0 && searchConfig.query && (0, _esQuery.isOfQueryType)(searchConfig.query) && typeof searchConfig.query.query === 'string') {
      fields.push(prebuildFields.customQuery(searchConfig.query.query));
    }
    if (searchConfig !== null && searchConfig !== void 0 && searchConfig.filter && Array.isArray(searchConfig.filter) && searchConfig.filter.length && typeof searchConfig.index === 'string') {
      fields.push(prebuildFields.queryFilters({
        filters: searchConfig.filter,
        dataViewId: searchConfig.index
      }));
    }
    return [...fields];
  }
  return [];
};
exports.getDescriptionFields = getDescriptionFields;