"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsQueryRuleTypeExpression = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _search_source_expression = require("./search_source_expression");
var _es_query_expression = require("./es_query_expression");
var _query_form_type_chooser = require("./query_form_type_chooser");
var _util = require("../util");
var _constants = require("../constants");
var _esql_query_expression = require("./esql_query_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/expression/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function areSearchSourceExpressionPropsEqual(prevProps, nextProps) {
  const areErrorsEqual = (0, _fastDeepEqual.default)(prevProps.errors, nextProps.errors);
  const areRuleParamsEqual = (0, _fastDeepEqual.default)(prevProps.ruleParams, nextProps.ruleParams);
  return areErrorsEqual && areRuleParamsEqual;
}
const SearchSourceExpressionMemoized = /*#__PURE__*/(0, _react.memo)(_search_source_expression.SearchSourceExpression, areSearchSourceExpressionPropsEqual);
const EsQueryRuleTypeExpression = props => {
  var _props$metadata$isMan, _props$metadata, _errors$timeField, _errors$searchConfigu;
  const {
    ruleParams,
    errors,
    setRuleProperty,
    setRuleParams
  } = props;
  const isSearchSource = (0, _util.isSearchSourceRule)(ruleParams);
  const isEsqlQuery = (0, _util.isEsqlQueryRule)(ruleParams);
  // metadata provided only when the user opens the alert from the Discover page or a dashboard
  const isManagementPage = (_props$metadata$isMan = (_props$metadata = props.metadata) === null || _props$metadata === void 0 ? void 0 : _props$metadata.isManagementPage) !== null && _props$metadata$isMan !== void 0 ? _props$metadata$isMan : true;
  const formTypeSelected = (0, _react.useCallback)(searchType => {
    if (!searchType) {
      // @ts-expect-error Reset rule params regardless of their type
      setRuleProperty('params', {});
      return;
    }
    setRuleParams('searchType', searchType);
  }, [setRuleParams, setRuleProperty]);
  const expressionGenericErrorMessage = _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertParams.fixErrorInExpressionBelowValidationMessage', {
    defaultMessage: 'Expression contains errors.'
  });
  const errorParam = _constants.ALL_EXPRESSION_ERROR_KEYS.find(errorKey => {
    var _errors$errorKey;
    return (
      // @ts-expect-error upgrade typescript v5.1.6
      ((_errors$errorKey = errors[errorKey]) === null || _errors$errorKey === void 0 ? void 0 : _errors$errorKey.length) >= 1 && ruleParams[errorKey] !== undefined
    );
  }) || (
  // For search source alerts, if the only error is timeField, show this error even if the param is undefined
  // timeField is inherently a part of the selectable data view, so if the user selects a data view with no
  // timeField, this data view is incompatible with the rule.
  isSearchSource && !!((_errors$timeField = errors.timeField) !== null && _errors$timeField !== void 0 && _errors$timeField.length) && !((_errors$searchConfigu = errors.searchConfiguration) !== null && _errors$searchConfigu !== void 0 && _errors$searchConfigu.length) ? 'timeField' : undefined);
  const expressionError = !!errorParam && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    size: "s",
    "data-test-subj": "esQueryAlertExpressionError",
    title: ['index', 'searchType', 'timeField'].includes(errorParam) ? errors[errorParam] : expressionGenericErrorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expressionError, isManagementPage && /*#__PURE__*/_react.default.createElement(_query_form_type_chooser.QueryFormTypeChooser, {
    searchType: ruleParams.searchType,
    onFormTypeSelect: formTypeSelected,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), ruleParams.searchType && isSearchSource && /*#__PURE__*/_react.default.createElement(SearchSourceExpressionMemoized, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })), ruleParams.searchType && !isSearchSource && !isEsqlQuery && /*#__PURE__*/_react.default.createElement(_es_query_expression.EsQueryExpression, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  })), ruleParams.searchType && isEsqlQuery && /*#__PURE__*/_react.default.createElement(_esql_query_expression.EsqlQueryExpression, (0, _extends2.default)({}, props, {
    ruleParams: ruleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
};
exports.EsQueryRuleTypeExpression = EsQueryRuleTypeExpression;