"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeFilter = exports.EsqlQueryExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _public2 = require("@kbn/esql/public");
var _esqlUtils = require("@kbn/esql-utils");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/triggers-actions-ui-plugin/public/common");
var _esqlAst = require("@kbn/esql-ast");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _types = require("../types");
var _constants = require("../constants");
var _util = require("../util");
var _validation = require("../validation");
var _test_query_row = require("../test_query_row");
var _common3 = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/expression/esql_query_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTimeFilter = (timeField, window) => {
  const timeWindow = (0, _common.parseDuration)(window);
  const now = Date.now();
  const dateEnd = new Date(now).toISOString();
  const dateStart = new Date(now - timeWindow).toISOString();
  return {
    timeRange: {
      from: dateStart,
      to: dateEnd
    },
    timeFilter: {
      bool: {
        filter: [{
          range: {
            [timeField]: {
              lte: dateEnd,
              gt: dateStart,
              format: 'strict_date_optional_time'
            }
          }
        }]
      }
    }
  };
};
exports.getTimeFilter = getTimeFilter;
const ALL_DOCUMENTS = 'all';
const alertingOptions = [{
  id: ALL_DOCUMENTS,
  label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.allDocumentsLabel', {
    defaultMessage: 'Create an alert if matches are found'
  })
}, {
  id: 'row',
  label: _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertPerRowLabel', {
    defaultMessage: 'Create an alert for each row'
  })
}];
const getWarning = (duplicateAlertIds, longAlertIds) => {
  if (duplicateAlertIds && duplicateAlertIds.size > 0) {
    return _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertPerRowWarning', {
      defaultMessage: 'Test returned multiple rows with the same alert ID. Consider updating the query to group on different fields.'
    });
  } else if (longAlertIds && longAlertIds.size > 0) {
    return _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.alertPerRowAlertIdWarning', {
      defaultMessage: 'The number of fields used to generate the alert ID should be limited to a maximum of {max}. ',
      values: {
        max: _common3.ALERT_ID_SUGGESTED_MAX
      }
    });
  }
};
const keepRecommendedWarning = _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.keepRecommendedWarning', {
  defaultMessage: 'KEEP processing command is recommended for ES|QL queries to limit the number of columns returned.'
});
const EsqlQueryExpression = ({
  ruleParams,
  metadata,
  setRuleParams,
  setRuleProperty,
  errors,
  data
}) => {
  const {
    http,
    isServerless,
    dataViews
  } = (0, _util.useTriggerUiActionServices)();
  const {
    esqlQuery,
    timeWindowSize,
    timeWindowUnit,
    timeField,
    groupBy
  } = ruleParams;
  const isEdit = !!(metadata !== null && metadata !== void 0 && metadata.isEdit);
  const [currentRuleParams, setCurrentRuleParams] = (0, _react.useState)({
    ...ruleParams,
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    // ESQL queries compare conditions within the ES query
    // so only 'met' results are returned, therefore the threshold should always be 0
    threshold: [0],
    thresholdComparator: _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    size: isServerless ? _constants.SERVERLESS_DEFAULT_VALUES.SIZE : _constants.DEFAULT_VALUES.SIZE,
    esqlQuery: esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
      esql: ''
    },
    aggType: _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: _constants.DEFAULT_VALUES.TERM_SIZE,
    searchType: _types.SearchType.esqlQuery,
    // The sourceFields param is ignored
    sourceFields: []
  });
  const [query, setQuery] = (0, _react.useState)(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : {
    esql: ''
  });
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([_common2.firstFieldOption]);
  const [detectedTimestamp, setDetectedTimestamp] = (0, _react.useState)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [radioIdSelected, setRadioIdSelected] = (0, _react.useState)(groupBy !== null && groupBy !== void 0 ? groupBy : ALL_DOCUMENTS);
  const [keepWarning, setKeepWarning] = (0, _react.useState)(undefined);
  const [touched, setTouched] = (0, _react.useState)(false);
  (0, _useDebounce.default)(() => {
    if (isEdit) {
      return;
    }
    const {
      ast: {
        commands
      },
      tokens
    } = _esqlAst.EsqlQuery.fromSrc(query.esql);
    if (!commands.some(command => command.name === 'keep')) {
      const lastLine = tokens[tokens.length - 1];
      setKeepWarning(`"Line ${(lastLine === null || lastLine === void 0 ? void 0 : lastLine.line) || 1}:0: ${keepRecommendedWarning}"`);
    } else {
      setKeepWarning(undefined);
    }
  }, 500, [isEdit, query]);
  const setParam = (0, _react.useCallback)((paramField, paramValue) => {
    setCurrentRuleParams(currentParams => ({
      ...currentParams,
      [paramField]: paramValue
    }));
    setRuleParams(paramField, paramValue);
  }, [setRuleParams]);
  const clearParam = (0, _react.useCallback)(paramField => {
    setCurrentRuleParams(currentParams => {
      const nextParams = {
        ...currentParams
      };
      delete nextParams[paramField];
      return nextParams;
    });
    setRuleParams(paramField, undefined);
  }, [setRuleParams]);
  const setDefaultExpressionValues = () => {
    setRuleProperty('params', currentRuleParams);
    if (esqlQuery !== null && esqlQuery !== void 0 && esqlQuery.esql) {
      refreshTimeFields(esqlQuery);
    }
  };
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onTestQuery = (0, _react.useCallback)(async () => {
    const isGroupAgg = (0, _common2.isPerRowAggregation)(groupBy);
    const window = `${timeWindowSize}${timeWindowUnit}`;
    const emptyResult = {
      testResults: {
        results: [],
        truncated: false
      },
      isGrouped: true,
      timeWindow: window
    };
    if ((0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless)) {
      return emptyResult;
    }
    setIsLoading(true);
    const {
      timeFilter,
      timeRange
    } = getTimeFilter(timeField, window);
    const table = await (0, _esqlUtils.getESQLResults)({
      esqlQuery: esqlQuery.esql,
      search: data.search.search,
      dropNullColumns: true,
      timeRange,
      filter: timeFilter
    });
    if (table.response) {
      const esqlTable = (0, _common3.transformToEsqlTable)(table.response);
      const {
        results,
        duplicateAlertIds,
        longAlertIds,
        rows,
        cols
      } = await (0, _common3.getEsqlQueryHits)(esqlTable, esqlQuery.esql, isGroupAgg, true);
      const warning = getWarning(duplicateAlertIds, longAlertIds);
      setIsLoading(false);
      return {
        testResults: (0, _common2.parseAggregationResults)(results),
        isGrouped: isGroupAgg,
        isGroupedByRow: isGroupAgg,
        timeWindow: window,
        preview: {
          cols,
          rows
        },
        ...(warning ? {
          warning
        } : {})
      };
    }
    setIsLoading(false);
    return emptyResult;
  }, [timeWindowSize, timeWindowUnit, currentRuleParams, esqlQuery, data.search.search, timeField, isServerless, groupBy]);
  const refreshTimeFields = (0, _react.useCallback)(async q => {
    const fetchTimeFieldsData = async queryObj => {
      try {
        const esqlDataView = await (0, _esqlUtils.getESQLAdHocDataview)({
          dataViewsService: dataViews,
          query: queryObj.esql,
          http
        });
        const indexPattern = esqlDataView.getIndexPattern();
        const currentEsFields = await (0, _public.getFields)(http, [indexPattern]);
        const newTimeFieldOptions = (0, _common2.getTimeFieldOptions)(currentEsFields);
        const timestampField = esqlDataView.timeFieldName;
        return {
          newTimeFieldOptions,
          timestampField
        };
      } catch (e) {
        return {
          newTimeFieldOptions: [],
          timestampField: undefined
        };
      }
    };
    const {
      newTimeFieldOptions,
      timestampField
    } = await fetchTimeFieldsData(q);
    setTimeFieldOptions([_common2.firstFieldOption, ...newTimeFieldOptions]);
    if (!timeField && timestampField) {
      setParam('timeField', timestampField);
    }
    if (!newTimeFieldOptions.find(({
      value
    }) => value === timeField)) {
      clearParam('timeField');
    }
    setDetectedTimestamp(timestampField);
  }, [timeField, setParam, clearParam, dataViews, http]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "queryEditor",
    "data-test-subj": "queryEsqlEditor",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.ESQLLangEditor, {
    query: query,
    onTextLangQueryChange: q => {
      setTouched(true);
      setQuery(q);
      setParam('esqlQuery', q);
      refreshTimeFields(q);
    },
    warning: touched && keepWarning ? keepWarning : undefined,
    onTextLangQuerySubmit: async () => {},
    detectedTimestamp: detectedTimestamp,
    hideRunQueryText: true,
    hideRunQueryButton: true,
    isLoading: isLoading,
    editorIsInline: true,
    expandToFitQueryOnMount: true,
    hasOutline: true,
    mergeExternalMessages: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_test_query_row.TestQueryRow, {
    fetch: onTestQuery,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(currentRuleParams, isServerless),
    showTable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeField",
    fullWidth: true
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    error: errors.timeField,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectEsqlQueryTimeFieldPrompt",
      defaultMessage: "Select a time field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: timeFieldOptions
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeField.length > 0 && timeField !== undefined,
    fullWidth: true,
    name: "timeField",
    "data-test-subj": "timeFieldSelect",
    value: timeField || '',
    onChange: e => {
      setParam('timeField', e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "alertGroup",
    fullWidth: true
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.groupBy.length > 0 && groupBy !== undefined,
    error: errors.groupBy,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectEsqlQueryGroupByPrompt",
      defaultMessage: "Select alert group",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "groupByRadioGroup",
    options: alertingOptions,
    idSelected: radioIdSelected,
    onChange: optionId => {
      setRadioIdSelected(optionId);
      setParam('groupBy', optionId);
    },
    name: "alertGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowSize"
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeWindowSize.length > 0,
    error: errors.timeWindowSize,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.setEsqlQueryTimeWindowPrompt",
      defaultMessage: "Set the time window",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    name: "timeWindowSize",
    "data-test-subj": "timeWindowSizeNumber"
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.timeWindowSize.length > 0,
    min: 0,
    value: timeWindowSize || '',
    onChange: e => {
      const {
        value
      } = e.target;
      const timeWindowSizeVal = value !== '' ? parseInt(value, 10) : undefined;
      setParam('timeWindowSize', timeWindowSizeVal);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "timeWindowUnit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    name: "timeWindowUnit",
    "data-test-subj": "timeWindowUnitSelect",
    value: timeWindowUnit,
    onChange: e => {
      setParam('timeWindowUnit', e.target.value);
    },
    options: (0, _common2.getTimeOptions)(timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : 1),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 13
    }
  })))));
};
exports.EsqlQueryExpression = EsqlQueryExpression;