"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSolutionBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/space_solution_badge/badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SolutionOptions = {
  es: {
    iconType: 'logoElasticsearch',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSolutionBadge.elasticsearch",
      defaultMessage: "Elasticsearch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    })
  },
  workplaceai: {
    iconType: 'logoElasticsearch',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSolutionBadge.workplaceai",
      defaultMessage: "Workplace AI",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    })
  },
  security: {
    iconType: 'logoSecurity',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSolutionBadge.security",
      defaultMessage: "Security",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    })
  },
  oblt: {
    iconType: 'logoObservability',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSolutionBadge.observability",
      defaultMessage: "Observability",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    })
  },
  classic: {
    iconType: 'logoElasticStack',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.spaceSolutionBadge.classic",
      defaultMessage: "Classic",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    })
  }
};
const SpaceSolutionBadge = ({
  solution,
  ...badgeProps
}) => {
  const {
    iconType,
    label
  } = (0, _react.useMemo)(() => {
    if (!solution || !SolutionOptions[solution]) {
      return SolutionOptions.classic;
    }
    return SolutionOptions[solution];
  }, [solution]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({}, badgeProps, {
    iconType: iconType,
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }), label);
};
exports.SpaceSolutionBadge = SpaceSolutionBadge;