"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionViewTour = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/nav_control/solution_view_tour/solution_view_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const solutionMap = {
  es: _i18n.i18n.translate('xpack.spaces.navControl.tour.esSolution', {
    defaultMessage: 'Elasticsearch'
  }),
  security: _i18n.i18n.translate('xpack.spaces.navControl.tour.securitySolution', {
    defaultMessage: 'Elastic Security'
  }),
  oblt: _i18n.i18n.translate('xpack.spaces.navControl.tour.obltSolution', {
    defaultMessage: 'Elastic Observability'
  }),
  workplaceai: _i18n.i18n.translate('xpack.spaces.navControl.tour.workplaceAiSolution', {
    defaultMessage: 'Elastic Workplace AI'
  })
};
const SolutionViewTour = ({
  children,
  solution,
  isTourOpen,
  onFinishTour,
  manageSpacesLink,
  manageSpacesDocsLink,
  navigateToUrl
}) => {
  const solutionLabel = solution && solution !== _constants.SOLUTION_VIEW_CLASSIC ? solutionMap[solution] : '';
  if (!solutionLabel) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.navControl.tour.content",
      defaultMessage: "Only {solution} features are visible.{br}To access feature from other solutions, edit your {spacesLink} or create new spaces.{br}{learnMore}",
      values: {
        solution: solutionLabel,
        spacesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: manageSpacesLink,
          onClick: e => {
            if (!(0, _sharedUxUtility.hasActiveModifierKey)(e)) {
              e.preventDefault();
              onFinishTour();
              navigateToUrl(manageSpacesLink);
            }
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.spaces.navControl.tour.spaceSettingsLink', {
          defaultMessage: 'space settings'
        })),
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: manageSpacesDocsLink,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.spaces.navControl.tour.learnMore', {
          defaultMessage: 'Learn more'
        })),
        br: /*#__PURE__*/_react.default.createElement("br", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 21
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }))),
    isStepOpen: isTourOpen,
    minWidth: 300,
    maxWidth: 360,
    onFinish: onFinishTour,
    step: 1,
    stepsTotal: 1,
    repositionOnScroll: true,
    title: _i18n.i18n.translate('xpack.spaces.navControl.tour.title', {
      defaultMessage: 'This space uses the {solution} solution view',
      values: {
        solution: solutionLabel
      }
    }),
    anchorPosition: "downCenter",
    footerAction: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: onFinishTour,
      "data-test-subj": "closeTourBtn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.spaces.navControl.tour.closeBtn', {
      defaultMessage: 'Close'
    }))],
    panelProps: {
      'data-test-subj': 'spaceSolutionTour'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
};
exports.SolutionViewTour = SolutionViewTour;