"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spacesManagementApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/management/spaces_management_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spacesManagementApp = exports.spacesManagementApp = Object.freeze({
  id: 'spaces',
  create({
    getStartServices,
    spacesManager,
    config,
    logger,
    eventTracker,
    getIsRoleManagementEnabled,
    getRolesAPIClient,
    getPrivilegesAPIClient,
    isServerless,
    getSecurityLicense
  }) {
    const title = _i18n.i18n.translate('xpack.spaces.displayName', {
      defaultMessage: 'Spaces'
    });
    return {
      id: this.id,
      order: 2,
      title,
      async mount({
        element,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart, {
          features
        }], {
          SpacesGridPage
        }, {
          CreateSpacePage
        }, {
          EditSpacePage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./spaces_grid'))), Promise.resolve().then(() => _interopRequireWildcard(require('./create_space'))), Promise.resolve().then(() => _interopRequireWildcard(require('./edit_space')))]);
        const spacesFirstBreadcrumb = {
          text: title,
          href: `/`
        };
        const {
          notifications,
          application,
          chrome,
          http,
          overlays,
          docLinks
        } = coreStart;
        const enableSecurityLink = docLinks.links.security.enableElasticSearchSecurityFeatures;
        chrome.docTitle.change(title);
        const SpacesGridPageWithBreadcrumbs = () => {
          setBreadcrumbs([{
            ...spacesFirstBreadcrumb,
            href: undefined
          }]);
          return /*#__PURE__*/_react.default.createElement(SpacesGridPage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            serverBasePath: http.basePath.serverBasePath,
            history: history,
            getUrlForApp: application.getUrlForApp,
            maxSpaces: config.maxSpaces,
            allowSolutionVisibility: config.allowSolutionVisibility,
            isServerless: isServerless,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 92,
              columnNumber: 13
            }
          });
        };
        const CreateSpacePageWithBreadcrumbs = () => {
          setBreadcrumbs([spacesFirstBreadcrumb, {
            text: _i18n.i18n.translate('xpack.spaces.management.createSpaceBreadcrumb', {
              defaultMessage: 'Create'
            })
          }]);
          return /*#__PURE__*/_react.default.createElement(CreateSpacePage, {
            capabilities: application.capabilities,
            getFeatures: features.getFeatures,
            notifications: notifications,
            spacesManager: spacesManager,
            history: history,
            allowFeatureVisibility: config.allowFeatureVisibility,
            allowSolutionVisibility: config.allowSolutionVisibility,
            eventTracker: eventTracker,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 118,
              columnNumber: 13
            }
          });
        };
        const EditSpacePageWithBreadcrumbs = () => {
          const {
            spaceId,
            selectedTabId
          } = (0, _reactRouterDom.useParams)();
          const breadcrumbText = space => _i18n.i18n.translate('xpack.spaces.management.editSpaceBreadcrumb', {
            defaultMessage: 'Edit "{space}"',
            values: {
              space: space.name
            }
          });
          const onLoadSpace = space => {
            setBreadcrumbs([spacesFirstBreadcrumb, {
              text: breadcrumbText(space)
            }]);
          };
          return /*#__PURE__*/_react.default.createElement(EditSpacePage, {
            capabilities: application.capabilities,
            getUrlForApp: application.getUrlForApp,
            navigateToUrl: application.navigateToUrl,
            getSecurityLicense: getSecurityLicense,
            serverBasePath: http.basePath.serverBasePath,
            getFeatures: features.getFeatures,
            http: http,
            overlays: overlays,
            notifications: notifications,
            userProfile: coreStart.userProfile,
            theme: coreStart.theme,
            i18n: coreStart.i18n,
            logger: logger,
            spacesManager: spacesManager,
            spaceId: spaceId,
            onLoadSpace: onLoadSpace,
            history: history,
            selectedTabId: selectedTabId,
            getIsRoleManagementEnabled: getIsRoleManagementEnabled,
            getRolesAPIClient: getRolesAPIClient,
            allowFeatureVisibility: config.allowFeatureVisibility,
            allowSolutionVisibility: config.allowSolutionVisibility,
            getPrivilegesAPIClient: getPrivilegesAPIClient,
            enableSecurityLink: enableSecurityLink,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 153,
              columnNumber: 13
            }
          });
        };
        (0, _reactDom.render)(coreStart.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
          services: coreStart,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 184,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
          coreStart: coreStart,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 185,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
          history: history,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 187,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['', '/'],
          exact: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(SpacesGridPageWithBreadcrumbs, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: "/create",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 191,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(CreateSpacePageWithBreadcrumbs, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 192,
            columnNumber: 23
          }
        })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
          path: ['/edit/:spaceId', '/edit/:spaceId/:selectedTabId'],
          exact: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(EditSpacePageWithBreadcrumbs, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 195,
            columnNumber: 23
          }
        }))))))), element);
        return () => {
          chrome.docTitle.reset();
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});