"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToSpaceFlyoutInternal = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _copy_to_space_flyout_footer = require("./copy_to_space_flyout_footer");
var _copy_to_space_form = require("./copy_to_space_form");
var _processing_copy_to_space = require("./processing_copy_to_space");
var _spaces_context = require("../../spaces_context");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/copy_saved_objects_to_space/components/copy_to_space_flyout_internal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INCLUDE_RELATED_DEFAULT = true;
const CREATE_NEW_COPIES_DEFAULT = true;
const OVERWRITE_ALL_DEFAULT = true;
const CopyToSpaceFlyoutInternal = props => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    spacesManager,
    spacesDataPromise,
    services
  } = (0, _spaces_context.useSpaces)();
  const {
    notifications
  } = services;
  const toastNotifications = notifications.toasts;
  const {
    onClose = () => null,
    savedObjectTarget: object
  } = props;
  const savedObjectTarget = (0, _react.useMemo)(() => ({
    type: object.type,
    id: object.id,
    namespaces: object.namespaces,
    icon: object.icon || 'apps',
    title: object.title || `${object.type} [id=${object.id}]`
  }), [object]);
  const [copyOptions, setCopyOptions] = (0, _react.useState)({
    includeRelated: INCLUDE_RELATED_DEFAULT,
    createNewCopies: CREATE_NEW_COPIES_DEFAULT,
    overwrite: OVERWRITE_ALL_DEFAULT,
    selectedSpaceIds: []
  });
  const [{
    isLoading,
    spaces
  }, setSpacesState] = (0, _react.useState)({
    isLoading: true,
    spaces: []
  });
  (0, _react.useEffect)(() => {
    spacesDataPromise.then(({
      spacesMap
    }) => {
      setSpacesState({
        isLoading: false,
        spaces: [...spacesMap.values()].filter(({
          isActiveSpace,
          isAuthorizedForPurpose
        }) => !isActiveSpace && isAuthorizedForPurpose('copySavedObjectsIntoSpace'))
      });
    }).catch(e => {
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.spacesLoadErrorTitle', {
          defaultMessage: 'Error loading available spaces'
        })
      });
    });
  }, [spacesDataPromise, toastNotifications]);
  const [copyInProgress, setCopyInProgress] = (0, _react.useState)(false);
  const [conflictResolutionInProgress, setConflictResolutionInProgress] = (0, _react.useState)(false);
  const [copyResult, setCopyResult] = (0, _react.useState)({});
  const [retries, setRetries] = (0, _react.useState)({});
  const initialCopyFinished = Object.values(copyResult).length > 0;
  const onRetriesChange = updatedRetries => {
    setRetries(updatedRetries);
  };
  async function startCopy() {
    setCopyInProgress(true);
    setCopyResult({});
    try {
      const copySavedObjectsResult = await spacesManager.copySavedObjects([{
        type: savedObjectTarget.type,
        id: savedObjectTarget.id
      }], copyOptions.selectedSpaceIds, copyOptions.includeRelated, copyOptions.createNewCopies, copyOptions.overwrite);
      const processedResult = (0, _lodash.mapValues)(copySavedObjectsResult, _lib.processImportResponse);
      setCopyResult(processedResult);

      // retry all successful imports
      const getAutomaticRetries = response => {
        const {
          failedImports,
          successfulImports
        } = response;
        if (!failedImports.length) {
          // if no imports failed for this space, return an empty array
          return [];
        }

        // get missing references failures that do not also have a conflict
        const nonMissingReferencesFailures = failedImports.filter(({
          error
        }) => error.type !== 'missing_references').reduce((acc, {
          obj: {
            type,
            id
          }
        }) => acc.add(`${type}:${id}`), new Set());
        const missingReferencesToRetry = failedImports.filter(({
          obj: {
            type,
            id
          },
          error
        }) => error.type === 'missing_references' && !nonMissingReferencesFailures.has(`${type}:${id}`));

        // otherwise, some imports failed for this space, so retry any successful imports (if any)
        return [...successfulImports.map(({
          type,
          id,
          overwrite,
          destinationId,
          createNewCopy
        }) => {
          return {
            type,
            id,
            overwrite: overwrite === true,
            destinationId,
            createNewCopy
          };
        }), ...missingReferencesToRetry.map(({
          obj: {
            type,
            id
          }
        }) => ({
          type,
          id,
          overwrite: false,
          ignoreMissingReferences: true
        }))];
      };
      const automaticRetries = (0, _lodash.mapValues)(processedResult, getAutomaticRetries);
      setRetries(automaticRetries);
    } catch (e) {
      setCopyInProgress(false);
      toastNotifications.addError(e, {
        title: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.copyErrorTitle', {
          defaultMessage: 'Error copying saved object'
        })
      });
    }
  }
  async function finishCopy() {
    // if any retries are present, attempt to resolve errors again
    const needsErrorResolution = Object.values(retries).some(spaceRetry => spaceRetry.length);
    if (needsErrorResolution) {
      setConflictResolutionInProgress(true);
      try {
        await spacesManager.resolveCopySavedObjectsErrors([{
          type: savedObjectTarget.type,
          id: savedObjectTarget.id
        }], retries, copyOptions.includeRelated, copyOptions.createNewCopies);
        toastNotifications.addSuccess(_i18n.i18n.translate('xpack.spaces.management.copyToSpace.resolveCopySuccessTitle', {
          defaultMessage: 'Copy successful'
        }));
        onClose();
      } catch (e) {
        setCopyInProgress(false);
        toastNotifications.addError(e, {
          title: _i18n.i18n.translate('xpack.spaces.management.copyToSpace.resolveCopyErrorTitle', {
            defaultMessage: 'Error resolving saved object conflicts'
          })
        });
      }
    } else {
      onClose();
    }
  }
  const getFlyoutBody = () => {
    // Step 1: loading assets for main form
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 14
        }
      });
    }

    // Step 1a: assets loaded, but no spaces are available for copy.
    if (spaces.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 207,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.spaces.management.copyToSpace.noSpacesBody",
          defaultMessage: "There are no eligible spaces to copy into.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 208,
            columnNumber: 15
          }
        })),
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 215,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.spaces.management.copyToSpace.noSpacesTitle",
          defaultMessage: "No spaces available",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 216,
            columnNumber: 15
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 9
        }
      });
    }

    // Step 2: Copy has not been initiated yet; User must fill out form to continue.
    if (!copyInProgress) {
      return /*#__PURE__*/_react.default.createElement(_copy_to_space_form.CopyToSpaceForm, {
        savedObjectTarget: savedObjectTarget,
        spaces: spaces,
        copyOptions: copyOptions,
        onUpdate: setCopyOptions,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 9
        }
      });
    }

    // Step3: Copy operation is in progress
    return /*#__PURE__*/_react.default.createElement(_processing_copy_to_space.ProcessingCopyToSpace, {
      savedObjectTarget: savedObjectTarget,
      copyInProgress: copyInProgress,
      conflictResolutionInProgress: conflictResolutionInProgress,
      copyResult: copyResult,
      spaces: spaces,
      copyOptions: copyOptions,
      retries: retries,
      onRetriesChange: onRetriesChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    maxWidth: 600,
    "data-test-subj": "copy-to-space-flyout",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "copy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpaceFlyoutHeader",
    defaultMessage: "Copy to spaces",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: savedObjectTarget.icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  }, savedObjectTarget.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  }), getFlyoutBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_copy_to_space_flyout_footer.CopyToSpaceFlyoutFooter, {
    copyInProgress: copyInProgress,
    conflictResolutionInProgress: conflictResolutionInProgress,
    initialCopyFinished: initialCopyFinished,
    copyResult: copyResult,
    numberOfSelectedSpaces: copyOptions.selectedSpaceIds.length,
    retries: retries,
    onClose: onClose,
    onCopyStart: startCopy,
    onCopyFinish: finishCopy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  })));
};
exports.CopyToSpaceFlyoutInternal = CopyToSpaceFlyoutInternal;