"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../constants");
var _app_context = require("../../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/snapshot_list/snapshot_details/tabs/snapshot_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SnapshotState = ({
  state,
  displayTooltipIcon
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const stateMap = {
    [_constants.SNAPSHOT_STATE.IN_PROGRESS]: {
      color: 'primary',
      label: i18n.translate('xpack.snapshotRestore.snapshotState.inProgressLabel', {
        defaultMessage: 'In progress'
      })
    },
    [_constants.SNAPSHOT_STATE.SUCCESS]: {
      color: 'success',
      label: i18n.translate('xpack.snapshotRestore.snapshotState.completeLabel', {
        defaultMessage: 'Complete'
      })
    },
    [_constants.SNAPSHOT_STATE.FAILED]: {
      color: 'danger',
      label: i18n.translate('xpack.snapshotRestore.snapshotState.failedLabel', {
        defaultMessage: 'Failed'
      })
    },
    [_constants.SNAPSHOT_STATE.PARTIAL]: {
      color: 'warning',
      label: i18n.translate('xpack.snapshotRestore.snapshotState.partialLabel', {
        defaultMessage: 'Partial'
      }),
      tip: i18n.translate('xpack.snapshotRestore.snapshotState.partialTipDescription', {
        defaultMessage: `Global cluster state was stored, but at least one shard wasn't stored successfully. See the 'Failed indices' tab.`
      })
    }
  };
  if (!stateMap[state]) {
    // Help debug unexpected state.
    return state;
  }
  const {
    color,
    label,
    tip
  } = stateMap[state];
  const iconTip = displayTooltipIcon && tip && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 48
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, label), iconTip));
};
exports.SnapshotState = SnapshotState;