"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
var _shards_table = require("./shards_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/restore_list/restore_table/restore_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RestoreTable = exports.RestoreTable = /*#__PURE__*/_react.default.memo(({
  restores
}) => {
  const {
    i18n,
    uiMetricService
  } = (0, _app_context.useServices)();
  const [tableState, setTableState] = (0, _react.useState)({
    page: {},
    sort: {}
  });

  // Track expanded indices
  const [expandedIndices, setExpandedIndices] = (0, _react.useState)({});
  const getPagination = () => {
    const {
      index: pageIndex,
      size: pageSize
    } = tableState.page;
    return {
      pageIndex: pageIndex !== null && pageIndex !== void 0 ? pageIndex : 0,
      pageSize: pageSize !== null && pageSize !== void 0 ? pageSize : 20,
      totalItemCount: restores.length,
      pageSizeOptions: [10, 20, 50]
    };
  };
  const getSorting = () => {
    const {
      field: sortField,
      direction: sortDirection
    } = tableState.sort;
    return {
      sort: {
        field: sortField !== null && sortField !== void 0 ? sortField : 'isComplete',
        direction: sortDirection !== null && sortDirection !== void 0 ? sortDirection : 'asc'
      }
    };
  };
  const getRestores = () => {
    const newRestoresList = [...restores];
    const {
      sort: {
        field,
        direction
      }
    } = getSorting();
    const {
      pageIndex,
      pageSize
    } = getPagination();
    const sortedRestores = (0, _lodash.orderBy)(newRestoresList, [field], [direction]);
    return sortedRestores.slice(pageIndex * pageSize, (pageIndex + 1) * pageSize);
  };

  // On sorting and pagination change
  const onTableChange = ({
    page = {},
    sort = {}
  }) => {
    setTableState({
      page,
      sort
    });
  };

  // Expand or collapse index details
  const toggleIndexRestoreDetails = restore => {
    const {
      index
    } = restore;
    const isExpanded = Boolean(itemIdToExpandedRowMap[index]) ? false : true;
    if (isExpanded === true) {
      uiMetricService.trackUiMetric(_constants.UIM_RESTORE_LIST_EXPAND_INDEX);
    }
    setExpandedIndices({
      ...itemIdToExpandedRowMap,
      [index]: isExpanded
    });
  };
  const itemIdToExpandedRowMap = (0, _react.useMemo)(() => {
    return restores.reduce((acc, restore) => {
      const {
        index,
        shards
      } = restore;
      if (expandedIndices[index]) {
        acc[index] = /*#__PURE__*/_react.default.createElement(_shards_table.ShardsTable, {
          shards: shards,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 22
          }
        });
      }
      return acc;
    }, {});
  }, [expandedIndices, restores]);
  const columns = [{
    field: 'index',
    name: i18n.translate('xpack.snapshotRestore.restoreList.table.indexColumnTitle', {
      defaultMessage: 'Index'
    }),
    truncateText: true,
    sortable: true,
    'data-test-subj': 'restoreTableIndex'
  }, {
    field: 'isComplete',
    name: i18n.translate('xpack.snapshotRestore.restoreList.table.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    truncateText: true,
    sortable: true,
    'data-test-subj': 'restoreTableIsComplete',
    render: isComplete => isComplete ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.table.statusColumn.completeLabel",
      defaultMessage: "Complete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.table.statusColumn.inProgressLabel",
      defaultMessage: "In progress",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }))
  }, {
    field: 'latestActivityTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.table.lastActivityTitle', {
      defaultMessage: 'Last activity'
    }),
    truncateText: true,
    render: (latestActivityTimeInMillis, {
      isComplete
    }) => {
      return isComplete ? /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
        epochMs: latestActivityTimeInMillis,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreList.table.lastActivityColumn.nowLabel",
        defaultMessage: "now",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'shards',
    name: i18n.translate('xpack.snapshotRestore.restoreList.table.shardsCompletedTitle', {
      defaultMessage: 'Shards completed'
    }),
    truncateText: true,
    render: shards => {
      return shards.filter(shard => Boolean(shard.stopTimeInMillis)).length;
    }
  }, {
    field: 'shards',
    name: i18n.translate('xpack.snapshotRestore.restoreList.table.shardsInProgressTitle', {
      defaultMessage: 'Shards in progress'
    }),
    truncateText: true,
    render: shards => {
      return shards.filter(shard => !Boolean(shard.stopTimeInMillis)).length;
    }
  }, {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleIndexRestoreDetails(item),
      "aria-label": itemIdToExpandedRowMap[item.index] ? 'Collapse' : 'Expand',
      iconType: itemIdToExpandedRowMap[item.index] ? 'arrowUp' : 'arrowDown',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: getRestores(),
    itemId: "index",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    columns: columns,
    sorting: getSorting(),
    pagination: getPagination(),
    onChange: onTableChange,
    rowProps: restore => ({
      'data-test-subj': 'row',
      onClick: () => toggleIndexRestoreDetails(restore)
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "restoresTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 5
    }
  });
});