"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../../common/constants");
var _azure_details = require("./azure_details");
var _default_details = require("./default_details");
var _fs_details = require("./fs_details");
var _gcs_details = require("./gcs_details");
var _hdfs_details = require("./hdfs_details");
var _readonly_details = require("./readonly_details");
var _s3_details = require("./s3_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/repository_list/repository_details/type_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TypeDetails = ({
  repository
}) => {
  const {
    type,
    settings
  } = repository;
  switch (type) {
    case _constants.REPOSITORY_TYPES.fs:
      return /*#__PURE__*/_react.default.createElement(_fs_details.FSDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.url:
      return /*#__PURE__*/_react.default.createElement(_readonly_details.ReadonlyDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.source:
      const {
        delegateType
      } = settings;
      const delegatedRepository = {
        ...repository,
        type: delegateType
      };
      return /*#__PURE__*/_react.default.createElement(TypeDetails, {
        repository: delegatedRepository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.azure:
      return /*#__PURE__*/_react.default.createElement(_azure_details.AzureDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.gcs:
      return /*#__PURE__*/_react.default.createElement(_gcs_details.GCSDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.hdfs:
      return /*#__PURE__*/_react.default.createElement(_hdfs_details.HDFSDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 14
        }
      });
    case _constants.REPOSITORY_TYPES.s3:
      return /*#__PURE__*/_react.default.createElement(_s3_details.S3Details, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 14
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_default_details.DefaultDetails, {
        repository: repository,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 14
        }
      });
  }
};
exports.TypeDetails = TypeDetails;