"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
var _navigation = require("../../../../services/navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/policy_list/policy_table/policy_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  /*
   * 1. Make in progress snapshot loading indicator be centered vertically
   *    when it is inside tooltip wrapper
   */
  policyTable: (0, _react2.css)`
    .euiToolTipAnchor {
      display: flex;
    }
  `
};
const PolicyTable = ({
  policies,
  reload,
  openPolicyDetailsUrl,
  onPolicyDeleted,
  onPolicyExecuted
}) => {
  const {
    i18n,
    uiMetricService,
    history
  } = (0, _app_context.useServices)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.policyNameColumnTitle', {
      defaultMessage: 'Policy'
    }),
    truncateText: true,
    sortable: true,
    render: (name, {
      inProgress,
      isManagedPolicy
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, openPolicyDetailsUrl(name), () => uiMetricService.trackUiMetric(_constants.UIM_POLICY_SHOW_DETAILS_CLICK)), {
        "data-test-subj": "policyLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 15
        }
      }), name), ' '), isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyList.table.managedPolicyBadgeLabel",
          defaultMessage: "This is a managed policy",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 21
          }
        }),
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 17
        }
      })) : null, inProgress ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: i18n.translate('xpack.snapshotRestore.policyList.table.inProgressTooltip', {
          defaultMessage: 'Snapshot in progress'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 19
        }
      }))) : null);
    }
  }, {
    field: 'snapshotName',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.snapshotNameColumnTitle', {
      defaultMessage: 'Snapshot name'
    }),
    sortable: true,
    render: (snapshotName, {
      lastFailure,
      lastSuccess
    }) => {
      // Alert user if last snapshot failed
      if (lastSuccess && lastFailure && lastFailure.time > lastSuccess.time) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "top",
          content: i18n.translate('xpack.snapshotRestore.policyList.table.lastSnapshotFailedTooltip', {
            defaultMessage: 'Last snapshot failed'
          }),
          type: "warning",
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 134,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 17
          }
        }, snapshotName)));
      }
      return snapshotName;
    }
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    }),
    truncateText: true,
    sortable: true
  }, {
    field: 'schedule',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.scheduleColumnTitle', {
      defaultMessage: 'Schedule'
    }),
    truncateText: true,
    sortable: true
  }, {
    field: 'retention',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.retentionColumnTitle', {
      defaultMessage: 'Retention'
    }),
    render: retention => retention ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.retentionColumnAriaLabel', {
        defaultMessage: 'Retention configured'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }) : null
  }, {
    field: 'nextExecutionMillis',
    name: i18n.translate('xpack.snapshotRestore.policyList.table.nextExecutionColumnTitle', {
      defaultMessage: 'Next snapshot'
    }),
    truncateText: true,
    sortable: true,
    render: nextExecutionMillis => /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: nextExecutionMillis,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 9
      }
    })
  }, {
    name: i18n.translate('xpack.snapshotRestore.policyList.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: ({
        name,
        inProgress,
        isManagedPolicy
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 208,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 209,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_components.PolicyExecuteProvider, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 210,
            columnNumber: 19
          }
        }, executePolicyPrompt => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: Boolean(inProgress) ? i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteDisabledTooltip', {
              defaultMessage: 'Policy is running'
            }) : i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteTooltip', {
              defaultMessage: 'Run now'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 213,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionExecuteAriaLabel', {
              defaultMessage: `Run ''{name}'' immediately`,
              values: {
                name
              }
            }),
            iconType: "play",
            color: "primary",
            "data-test-subj": "executePolicyButton",
            onClick: () => executePolicyPrompt(name, onPolicyExecuted),
            disabled: Boolean(inProgress),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 226,
              columnNumber: 27
            }
          }));
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 245,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.translate('xpack.snapshotRestore.policyList.table.actionEditTooltip', {
            defaultMessage: 'Edit'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
          "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionEditAriaLabel', {
            defaultMessage: `Edit policy ''{name}''`,
            values: {
              name
            }
          }),
          iconType: "pencil",
          color: "primary"
        }, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToEditPolicy)(name)), {
          "data-test-subj": "editPolicyButton",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 252,
            columnNumber: 21
          }
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 268,
            columnNumber: 19
          }
        }, deletePolicyPrompt => {
          const label = !isManagedPolicy ? i18n.translate('xpack.snapshotRestore.policyList.table.actionDeleteTooltip', {
            defaultMessage: 'Delete'
          }) : i18n.translate('xpack.snapshotRestore.policyList.table.deleteManagedPolicyTableActionTooltip', {
            defaultMessage: 'You cannot delete a managed policy.'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: label,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 282,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
            "aria-label": i18n.translate('xpack.snapshotRestore.policyList.table.actionDeleteAriaLabel', {
              defaultMessage: `Delete policy ''{name}''`,
              values: {
                name
              }
            }),
            iconType: "trash",
            color: "danger",
            "data-test-subj": "deletePolicyButton",
            onClick: () => deletePolicyPrompt([name], onPolicyDeleted),
            isDisabled: isManagedPolicy,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 283,
              columnNumber: 27
            }
          }));
        })));
      }
    }],
    width: '100px'
  }];
  const sorting = {
    sort: {
      field: 'name',
      direction: 'asc'
    }
  };
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50]
  };
  const selection = {
    onSelectionChange: newSelectedItems => setSelectedItems(newSelectedItems),
    selectable: ({
      isManagedPolicy
    }) => !isManagedPolicy,
    selectableMessage: selectable => {
      if (!selectable) {
        return i18n.translate('xpack.snapshotRestore.policyList.table.deleteManagedPolicySelectTooltip', {
          defaultMessage: 'You cannot delete a managed policy.'
        });
      }
      return '';
    }
  };
  const search = {
    toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.PolicyDeleteProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 7
      }
    }, deletePolicyPrompt => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: () => deletePolicyPrompt(selectedItems.map(({
          name
        }) => name), onPolicyDeleted),
        color: "danger",
        "data-test-subj": "srPolicyListBulkDeleteActionButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.table.deletePolicyButton",
        defaultMessage: "Delete {count, plural, one {policy} other {policies}}",
        values: {
          count: selectedItems.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 15
        }
      }));
    }) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "reloadPolicies",
      color: "success",
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "reloadButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.table.reloadPoliciesButton",
      defaultMessage: "Reload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      key: "createNewPolicy"
    }, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddPolicy)()), {
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "createPolicyButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 384,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.table.addPolicyButton",
      defaultMessage: "Create policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 9
      }
    }))],
    box: {
      incremental: true,
      schema: true
    },
    filters: [{
      type: 'field_value_selection',
      field: 'repository',
      name: i18n.translate('xpack.snapshotRestore.policyList.table.repositoryFilterLabel', {
        defaultMessage: 'Repository'
      }),
      multiSelect: false,
      options: Object.keys(policies.reduce((repositoriesMap, policy) => {
        repositoriesMap[policy.repository] = true;
        return repositoriesMap;
      }, {})).map(repository => {
        return {
          value: repository,
          view: repository
        };
      })
    }]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    css: styles.policyTable,
    items: policies,
    itemId: "name",
    columns: columns,
    search: search,
    sorting: sorting,
    selection: selection,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "policyTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 5
    }
  });
};
exports.PolicyTable = PolicyTable;