"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _common = require("../../../../../common");
var _constants = require("../../../constants");
var _lib = require("../../../lib");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _app_context = require("../../../app_context");
var _policy_details = require("./policy_details");
var _policy_table = require("./policy_table");
var _policy_retention_schedule = require("./policy_retention_schedule");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/sections/home/policy_list/policy_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyList = ({
  history
}) => {
  const {
    policyName
  } = (0, _lib.useDecodedParams)();
  const {
    error,
    isLoading,
    data: {
      policies
    } = {
      policies: undefined
    },
    resendRequest: reload
  } = (0, _http.useLoadPolicies)();
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    core
  } = (0, _app_context.useAppContext)();
  const {
    docLinks
  } = (0, _app_context.useCore)();

  // Load retention cluster settings
  const {
    isLoading: isLoadingRetentionSettings,
    error: retentionSettingsError,
    data: retentionSettings,
    resendRequest: reloadRetentionSettings
  } = (0, _http.useLoadRetentionSettings)();
  const {
    data: slmStatus
  } = (0, _http.useLoadSlmStatus)();
  const openPolicyDetailsUrl = newPolicyName => {
    return (0, _navigation.linkToPolicy)(newPolicyName);
  };
  const closePolicyDetails = () => {
    history.push(`${_constants.BASE_PATH}/policies`);
  };
  const onPolicyDeleted = policiesDeleted => {
    if (policyName && policiesDeleted.includes(policyName)) {
      closePolicyDetails();
    }
    if (policiesDeleted.length) {
      reload();
    }
  };
  const onPolicyExecuted = () => {
    reload();
  };

  // Track component loaded
  (0, _react.useEffect)(() => {
    uiMetricService.trackUiMetric(_constants.UIM_POLICY_LIST_LOAD);
  }, [uiMetricService]);
  (0, _shared_imports.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'snapshotRestorePolicyTab'
  });
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.loadingPoliciesDescription",
      defaultMessage: "Loading policies\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.LoadingPoliciesErrorMessage",
        defaultMessage: "Error loading policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 11
        }
      }),
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    });
  } else if (policies && policies.length === 0) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "managementApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.emptyPromptTitle",
        defaultMessage: "Create your first snapshot policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyList.emptyPromptDescription",
        defaultMessage: "A policy automates the creation and deletion of snapshots.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 15
        }
      }))),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddPolicy)()), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createPolicyButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.createPolicyButton",
        defaultMessage: "Create a policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 13
        }
      })),
      "data-test-subj": "emptyPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    });
  } else {
    const hasRetention = Boolean(policies.find(policy => policy.retention));
    const isSlmRunning = (slmStatus === null || slmStatus === void 0 ? void 0 : slmStatus.operation_mode) === _constants.SLM_STATE.RUNNING;
    content = /*#__PURE__*/_react.default.createElement("section", {
      "data-test-subj": "policyList",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    }, !isSlmRunning ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.slmWarningTitle",
        defaultMessage: "Snapshot lifecycle management (SLM) is not running",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 17
        }
      }),
      color: "warning",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.slmWarningDescription",
      defaultMessage: "Policies are not being executed. You must restart SLM {slmDocLink}",
      values: {
        slmDocLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.snapshotRestore.slmStart,
          external: true,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.snapshotRestore.slmDocLink', {
          defaultMessage: 'using the API.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    })) : null, hasRetention ? /*#__PURE__*/_react.default.createElement(_policy_retention_schedule.PolicyRetentionSchedule, {
      retentionSettings: retentionSettings,
      onRetentionScheduleUpdated: reloadRetentionSettings,
      isLoading: isLoadingRetentionSettings,
      error: retentionSettingsError,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    }) : null, /*#__PURE__*/_react.default.createElement(_policy_table.PolicyTable, {
      policies: policies || [],
      reload: reload,
      openPolicyDetailsUrl: openPolicyDetailsUrl,
      onPolicyDeleted: onPolicyDeleted,
      onPolicyExecuted: onPolicyExecuted,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _common.APP_SLM_CLUSTER_PRIVILEGES.map(name => `cluster.${name}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  }, ({
    hasPrivileges,
    privilegesMissing
  }) => hasPrivileges ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policyName ? /*#__PURE__*/_react.default.createElement(_policy_details.PolicyDetails, {
    policyName: policyName,
    onClose: closePolicyDetails,
    onPolicyDeleted: onPolicyDeleted,
    onPolicyExecuted: onPolicyExecuted,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }) : null, content) : /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.deniedPrivilegeTitle",
      defaultMessage: "You're missing cluster privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 15
      }
    }),
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyList.deniedPrivilegeDescription",
      defaultMessage: "To manage Snapshot Lifecycle Policies, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
      values: {
        missingPrivileges: privilegesMissing.cluster.join(', '),
        privilegesCount: privilegesMissing.cluster.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }));
};
exports.PolicyList = PolicyList;