"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../../../common");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _azure_settings = require("./azure_settings");
var _fs_settings = require("./fs_settings");
var _gcs_settings = require("./gcs_settings");
var _hdfs_settings = require("./hdfs_settings");
var _readonly_settings = require("./readonly_settings");
var _s3_settings = require("./s3_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/repository_form/type_settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TypeSettings = ({
  repository,
  isManagedRepository,
  updateRepository,
  settingErrors
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    type,
    settings
  } = repository;
  const updateRepositorySettings = (updatedSettings, replaceSettings) => {
    if (replaceSettings) {
      updateRepository({
        settings: updatedSettings
      });
    } else {
      updateRepository({
        settings: {
          ...settings,
          ...updatedSettings
        }
      });
    }
  };
  const typeSettingsMap = {
    [_common.REPOSITORY_TYPES.fs]: _fs_settings.FSSettings,
    [_common.REPOSITORY_TYPES.url]: _readonly_settings.ReadonlySettings,
    [_common.REPOSITORY_TYPES.azure]: _azure_settings.AzureSettings,
    [_common.REPOSITORY_TYPES.gcs]: _gcs_settings.GCSSettings,
    [_common.REPOSITORY_TYPES.hdfs]: _hdfs_settings.HDFSSettings,
    [_common.REPOSITORY_TYPES.s3]: _s3_settings.S3Settings
  };
  const renderTypeSettings = repositoryType => {
    if (!repositoryType) {
      return null;
    }
    const RepositorySettings = typeSettingsMap[repositoryType];
    if (RepositorySettings) {
      return /*#__PURE__*/_react.default.createElement(RepositorySettings, {
        repository: repository,
        isManagedRepository: isManagedRepository,
        updateRepositorySettings: updateRepositorySettings,
        settingErrors: settingErrors,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryForm.errorUnknownRepositoryTypesTitle",
        defaultMessage: "Unknown repository type",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 11
        }
      }),
      error: {
        error: i18n.translate('xpack.snapshotRestore.repositoryForm.errorUnknownRepositoryTypesMessage', {
          defaultMessage: `The repository type ''{type}'' is not supported.`,
          values: {
            type: repositoryType
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    });
  };
  return type === _common.REPOSITORY_TYPES.source ? renderTypeSettings(settings.delegateType) : renderTypeSettings(type);
};
exports.TypeSettings = TypeSettings;