"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyStepLogistics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _constants = require("../../../constants");
var _http = require("../../../services/http");
var _navigation = require("../../../services/navigation");
var _ = require("../..");
var _disable_tooltip = require("../../disable_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_form/steps/step_logistics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyStepLogistics = ({
  policy,
  updatePolicy,
  isEditing,
  currentUrl,
  errors
}) => {
  // Load repositories for repository dropdown field
  const {
    error: errorLoadingRepositories,
    isLoading: isLoadingRepositories,
    data: {
      repositories
    } = {
      repositories: []
    },
    resendRequest: reloadRepositories
  } = (0, _http.useLoadRepositories)();
  const {
    i18n,
    history
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const [showRepositoryNotFoundWarning, setShowRepositoryNotFoundWarning] = (0, _react.useState)(false);

  // State for touched inputs
  const [touched, setTouched] = (0, _react.useState)({
    name: false,
    snapshotName: false,
    repository: false,
    schedule: false
  });

  // State for cron editor
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: _constants.DEFAULT_POLICY_SCHEDULE,
    frequency: _constants.DEFAULT_POLICY_FREQUENCY
  });
  const [isAdvancedCronVisible, setIsAdvancedCronVisible] = (0, _react.useState)(Boolean(policy.schedule && policy.schedule !== _constants.DEFAULT_POLICY_SCHEDULE));
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const renderNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameDescriptionTitle",
      defaultMessage: "Policy name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameDescription",
      defaultMessage: "A unique identifier for this policy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.nameLabel",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }),
    isInvalid: touched.name && Boolean(errors.name),
    error: errors.name,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: touched.name && Boolean(errors.name),
    defaultValue: policy.name,
    fullWidth: true,
    onBlur: () => setTouched({
      ...touched,
      name: true
    }),
    onChange: e => {
      updatePolicy({
        name: e.target.value
      });
    },
    placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepLogistics.namePlaceholder', {
      defaultMessage: 'daily-snapshots',
      description: 'Example SLM policy name. Similar to index names, do not use spaces in translation.'
    }),
    "data-test-subj": "nameInput",
    disabled: isEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
  const renderRepositoryField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescriptionTitle",
      defaultMessage: "Repository",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescription",
      defaultMessage: "The repository where you want to store the snapshots.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyRepositoryLabel",
      defaultMessage: "Repository",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }),
    isInvalid: touched.repository && Boolean(errors.repository),
    error: errors.repository,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, renderRepositorySelect()));
  const renderRepositorySelect = () => {
    if (isLoadingRepositories) {
      return /*#__PURE__*/_react.default.createElement(_.InlineLoading, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.loadingRepositoriesDescription",
        defaultMessage: "Loading repositories\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }));
    }
    if (errorLoadingRepositories) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.loadingRepositoriesErrorMessage",
          defaultMessage: "Error loading repositories",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 191,
            columnNumber: 13
          }
        }),
        error: errorLoadingRepositories,
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          onClick: () => reloadRepositories(),
          color: "danger",
          iconType: "refresh",
          "data-test-subj": "reloadRepositoriesButton",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 198,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.reloadRepositoriesButtonLabel",
          defaultMessage: "Reload repositories",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 15
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 9
        }
      });
    }
    if (repositories.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.noRepositoriesErrorTitle",
          defaultMessage: "You don't have any repositories",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 218,
            columnNumber: 13
          }
        }),
        error: {
          error: i18n.translate('xpack.snapshotRestore.policyForm.noRepositoriesErrorMessage', {
            defaultMessage: 'You must register a repository to store your snapshots.'
          })
        },
        actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToAddRepository)(currentUrl)), {
          color: "danger",
          iconType: "plusInCircle",
          "data-test-subj": "addRepositoryButton",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 229,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.addRepositoryButtonLabel",
          defaultMessage: "Register a repository",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 235,
            columnNumber: 15
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 9
        }
      });
    } else {
      if (!policy.repository) {
        updatePolicy({
          repository: repositories[0].name
        });
      }
    }
    const doesRepositoryExist = !!policy.repository && repositories.some(r => r.name === policy.repository);
    if (!doesRepositoryExist && !errors.repository) {
      updatePolicy(policy, {
        repositoryDoesNotExist: true
      });
    }
    if (showRepositoryNotFoundWarning !== !doesRepositoryExist) {
      setShowRepositoryNotFoundWarning(!doesRepositoryExist);
    }
    return /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
      isManaged: policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy,
      tooltipMessage: _disable_tooltip.MANAGED_POLICY_TOOLTIP_MESSAGE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: repositories.map(({
        name
      }) => ({
        value: name,
        text: name
      })),
      hasNoInitialSelection: !doesRepositoryExist,
      value: !doesRepositoryExist ? '' : policy.repository,
      onBlur: () => setTouched({
        ...touched,
        repository: true
      }),
      onChange: e => {
        updatePolicy({
          repository: e.target.value
        });
      },
      fullWidth: true,
      "data-test-subj": "repositorySelect",
      disabled: (policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy) && isEditing,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 9
      }
    }));
  };
  const renderSnapshotNameField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescriptionTitle",
      defaultMessage: "Snapshot name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescription",
      defaultMessage: "The name for the snapshots. A unique identifier is automatically added to each name.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameLabel",
      defaultMessage: "Snapshot name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 11
      }
    }),
    isInvalid: touched.snapshotName && Boolean(errors.snapshotName),
    error: errors.snapshotName,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpText",
      defaultMessage: "Supports date math expressions. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.date.dateMathIndexNames,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 324,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpTextDocLink",
          defaultMessage: "Learn more.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 325,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_disable_tooltip.DisableToolTip, {
    isManaged: policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy,
    tooltipMessage: _disable_tooltip.MANAGED_POLICY_TOOLTIP_MESSAGE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: policy.snapshotName,
    fullWidth: true,
    onChange: e => {
      updatePolicy({
        snapshotName: e.target.value
      });
    },
    onBlur: () => setTouched({
      ...touched,
      snapshotName: true
    }),
    placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNamePlaceholder', {
      defaultMessage: `'<daily-snap-{now/d}>'`,
      description: 'Example date math snapshot name. Keeping the same syntax is important: <SOME-TRANSLATION-{now/d}>'
    }),
    "data-test-subj": "snapshotNameInput",
    disabled: (policy === null || policy === void 0 ? void 0 : policy.isManagedPolicy) && isEditing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  }))));
  const renderScheduleField = () => /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 369,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescriptionTitle",
      defaultMessage: "Schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescription",
      defaultMessage: "The frequency at which to take the snapshots.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 5
    }
  }, isAdvancedCronVisible ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleLabel",
      defaultMessage: "Schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    }),
    isInvalid: touched.schedule && Boolean(errors.schedule),
    error: errors.schedule,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpText",
      defaultMessage: "Use cron expression. {docLink}",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.apis.cronExpressions,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 402,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpTextDocLink",
          defaultMessage: "Learn more.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 403,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: touched.schedule && Boolean(errors.schedule),
    defaultValue: policy.schedule,
    fullWidth: true,
    onChange: e => {
      updatePolicy({
        schedule: e.target.value
      });
    },
    onBlur: () => setTouched({
      ...touched,
      schedule: true
    }),
    placeholder: _constants.DEFAULT_POLICY_SCHEDULE,
    "data-test-subj": "advancedCronInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsAdvancedCronVisible(false);
      updatePolicy({
        schedule: simpleCron.expression
      });
    },
    "data-test-subj": "showBasicCronLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonBasicLabel",
    defaultMessage: "Create basic interval",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.CronEditor, {
    frequencyBlockList: ['MINUTE'] // ES disallows a frequency faster than 15m
    ,
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      updatePolicy({
        schedule: expression
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 450,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 473,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsAdvancedCronVisible(true);
    },
    "data-test-subj": "showAdvancedCronLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 474,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonAdvancedLabel",
    defaultMessage: "Create cron expression",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 15
    }
  })))));
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogisticsTitle",
    defaultMessage: "Logistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.apis.putSnapshotLifecyclePolicy,
    target: "_blank",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Logistics docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 514,
      columnNumber: 13
    }
  })))), showRepositoryNotFoundWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 524,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    "data-test-subj": "repositoryNotFoundWarning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundTitle",
      defaultMessage: "Repository not found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 15
      }
    }),
    role: "alert",
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundDescription",
    defaultMessage: "Repository {repo} does not exist. Please select an existing repository.",
    values: {
      repo: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 541,
          columnNumber: 31
        }
      }, policy.repository)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 7
    }
  }), renderNameField(), renderSnapshotNameField(), renderRepositoryField(), renderScheduleField());
};
exports.PolicyStepLogistics = PolicyStepLogistics;