"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MANAGED_REPOSITORY_TOOLTIP_MESSAGE = exports.MANAGED_POLICY_TOOLTIP_MESSAGE = exports.DisableToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/disable_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MANAGED_REPOSITORY_TOOLTIP_MESSAGE = exports.MANAGED_REPOSITORY_TOOLTIP_MESSAGE = _i18n.i18n.translate('xpack.snapshotRestore.repositoryForm.disableToolTip', {
  defaultMessage: 'This field is disabled because you are editing a managed repository.'
});
const MANAGED_POLICY_TOOLTIP_MESSAGE = exports.MANAGED_POLICY_TOOLTIP_MESSAGE = _i18n.i18n.translate('xpack.snapshotRestore.policyForm.disableToolTip', {
  defaultMessage: 'This field is disabled because you are editing a managed policy.'
});

/**
 * Component that wraps a given component (disabled field) with a tooltip if a repository
 * or policy is managed (isManaged === true).
 */

const DisableToolTip = ({
  isManaged,
  tooltipMessage,
  children,
  ...props
}) => {
  // Ensures that any implicitly passed down props from meta parent component via `cloneElement` like in EuiFormRow [here](https://github.com/elastic/eui/blob/bc9c0a0b3faab449f88e45a588dfe0a53d842cf7/packages/eui/src/components/form/form_row/form_row.tsx#L210-L213) are forwarded down to anchor element.
  // At the same time, explicitly provided props on anchor component, should always take precedence to avoid confusion.
  const childrenWithProps = /*#__PURE__*/(0, _react.cloneElement)(children, {
    ...props,
    ...children.props
  });
  return isManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipMessage,
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, childrenWithProps) : childrenWithProps;
};
exports.DisableToolTip = DisableToolTip;