"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindSLODefinitions = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _errors = require("../errors");
var _get_slo_health = require("./get_slo_health");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PER_PAGE = 1000;
const DEFAULT_PER_PAGE = 100;
const DEFAULT_PAGE = 1;
class FindSLODefinitions {
  constructor(repository, scopedClusterClient) {
    this.repository = repository;
    this.scopedClusterClient = scopedClusterClient;
  }
  async execute(params) {
    var _params$tags$split, _params$tags, _params$search;
    const tags = (_params$tags$split = (_params$tags = params.tags) === null || _params$tags === void 0 ? void 0 : _params$tags.split(',')) !== null && _params$tags$split !== void 0 ? _params$tags$split : [];
    const {
      results: definitions,
      ...result
    } = await this.repository.search((_params$search = params.search) !== null && _params$search !== void 0 ? _params$search : '', toPagination(params), {
      includeOutdatedOnly: !!params.includeOutdatedOnly,
      tags
    });
    if (params.includeHealth) {
      const getSLOHealth = new _get_slo_health.GetSLOHealth(this.scopedClusterClient, this.repository);
      const healthResponses = await getSLOHealth.execute({
        list: definitions.map(definition => ({
          sloId: definition.id,
          sloInstanceId: '*'
        }))
      });
      const healthBySloId = (0, _lodash.keyBy)(healthResponses, 'sloId');
      const resultsWithHealth = definitions.map(definition => {
        var _healthBySloId$defini, _healthBySloId$defini2;
        return {
          ...definition,
          state: (_healthBySloId$defini = healthBySloId[definition.id]) === null || _healthBySloId$defini === void 0 ? void 0 : _healthBySloId$defini.state,
          health: (_healthBySloId$defini2 = healthBySloId[definition.id]) === null || _healthBySloId$defini2 === void 0 ? void 0 : _healthBySloId$defini2.health
        };
      });
      return _sloSchema.findSloDefinitionsWithHealthResponseSchema.encode({
        page: result.page,
        perPage: result.perPage,
        total: result.total,
        results: resultsWithHealth
      });
    }
    return _sloSchema.findSloDefinitionsResponseSchema.encode({
      page: result.page,
      perPage: result.perPage,
      total: result.total,
      results: definitions
    });
  }
}
exports.FindSLODefinitions = FindSLODefinitions;
function toPagination(params) {
  const page = Number(params.page);
  const perPage = Number(params.perPage);
  if (!isNaN(perPage) && perPage > MAX_PER_PAGE) {
    throw new _errors.IllegalArgumentError(`perPage limit set to ${MAX_PER_PAGE}`);
  }
  return {
    page: !isNaN(page) && page >= 1 ? page : DEFAULT_PAGE,
    perPage: !isNaN(perPage) && perPage >= 1 ? perPage : DEFAULT_PER_PAGE
  };
}