"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosWelcomePage = SlosWelcomePage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _slo_outdated_callout = require("../../components/slo/slo_outdated_callout");
var _slo_permissions_callout = require("../../components/slo/slo_permissions_callout");
var _use_fetch_slo_list = require("../../hooks/use_fetch_slo_list");
var _use_license = require("../../hooks/use_license");
var _use_permissions = require("../../hooks/use_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_kibana = require("../../hooks/use_kibana");
var _illustration = _interopRequireDefault(require("./assets/illustration.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos_welcome/slos_welcome.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SlosWelcomePage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  const {
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)();
  const {
    total
  } = sloList !== null && sloList !== void 0 ? sloList : {
    total: 0
  };
  const hasSlosAndPermissions = total > 0 && hasRightLicense && (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllReadRequested) === true;
  const handleClickCreateSlo = () => {
    navigateToUrl(basePath.prepend(_paths.paths.sloCreate));
  };
  (0, _react.useEffect)(() => {
    if (hasSlosAndPermissions) {
      navigateToUrl(basePath.prepend(_paths.paths.slos));
    }
  }, [basePath, navigateToUrl, hasSlosAndPermissions]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosPageWelcomePrompt",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_outdated_callout.SloOutdatedCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_permissions_callout.SloPermissionsCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.title', {
      defaultMessage: 'Track and deliver on your SLOs'
    }))),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _illustration.default,
      alt: "",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    }),
    color: "transparent",
    layout: "horizontal",
    hasBorder: false,
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.messageParagraph1', {
      defaultMessage: 'Measure key metrics important to the business, such as service-level indicators and service-level objectives (SLIs/SLOs) to deliver on SLAs.'
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.messageParagraph2', {
      defaultMessage: 'Easily report the uptime and reliability of your services to stakeholders with real-time insights.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasRightLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.getStartedMessage', {
      defaultMessage: 'To get started, create your first SLO.'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11ySloListWelcomePromptCreateSloButton",
      fill: true,
      color: "primary",
      onClick: handleClickCreateSlo,
      disabled: !(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.buttonLabel', {
      defaultMessage: 'Create SLO'
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.needLicenseMessage', {
      defaultMessage: 'You need an Elastic Cloud subscription or Platinum license to use SLOs.'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      href: "https://www.elastic.co/cloud/elasticsearch-service/signup",
      target: "_blank",
      "data-test-subj": "slosPageWelcomePromptSignupForCloudButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.signupForCloud', {
      defaultMessage: 'Sign up for Elastic Cloud'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: "https://www.elastic.co/subscriptions",
      target: "_blank",
      "data-test-subj": "slosPageWelcomePromptSignupForLicenseButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.signupForLicense', {
      defaultMessage: 'Sign up for license'
    }))))))),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.learnMore', {
      defaultMessage: 'Want to learn more?'
    }))), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "o11ySloListWelcomePromptReadTheDocsLink",
      href: docLinks.links.observability.slo,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.sloList.welcomePrompt.learnMoreLink', {
      defaultMessage: 'Read the docs'
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
}