"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomKqlIndicatorTypeForm = CustomKqlIndicatorTypeForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_create_data_view = require("../../../../../hooks/use_create_data_view");
var _data_preview_chart = require("../../common/data_preview_chart");
var _group_by_field = require("../../common/group_by_field");
var _query_builder = require("../../common/query_builder");
var _index_and_timestamp_field = require("../custom_common/index_and_timestamp_field");
var _index_selection = require("../custom_common/index_selection");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/custom_kql/custom_kql_indicator_type_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CustomKqlIndicatorTypeForm() {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const dataViewId = watch(_index_selection.DATA_VIEW_FIELD);
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index,
    dataViewId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_index_and_timestamp_field.IndexAndTimestampField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormQueryFilterInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormGoodQueryInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.goodQuery', {
      defaultMessage: 'Good query'
    }),
    name: "indicator.params.good",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.goodQueryPlaceholder', {
      defaultMessage: 'Define the good events'
    }),
    required: true,
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.goodQuery.tooltip', {
        defaultMessage: 'This KQL query should return a subset of events that are considered "good" or "successful" for the purpose of calculating the SLO. The query should filter events based on some relevant criteria, such as status codes, error messages, or other relevant fields.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customKqlIndicatorFormTotalQueryInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.totalQuery', {
      defaultMessage: 'Total query'
    }),
    name: "indicator.params.total",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.totalQueryPlaceholder', {
      defaultMessage: 'Define the total events'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customKql.totalQuery.tooltip', {
        defaultMessage: 'This KQL query should return all events that are relevant to the SLO calculation, including both good and bad events.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
}