"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsTable = DocumentsTable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _cellActions = require("@kbn/cell-actions");
var _discoverUtils = require("@kbn/discover-utils");
var _sloSchema = require("@kbn/slo-schema");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../hooks/use_kibana");
var _query_search_bar = require("./query_search_bar");
var _use_table_docs = require("./use_table_docs");
var _use_field_sidebar = require("./use_field_sidebar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/documents_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DocumentsTable({
  dataView,
  name,
  searchBarProps
}) {
  const services = (0, _use_kibana.useKibana)().services;
  const {
    setValue,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const filter = watch(name);
  const [range, setRange] = (0, _react.useState)({
    from: 'now-1d',
    to: 'now'
  });
  const [sampleSize, setSampleSize] = (0, _react.useState)(100);
  const [columns, setColumns] = (0, _react.useState)([]);
  const [sizes, setSizes] = (0, _react.useState)({
    fieldsPanel: 180,
    documentsPanel: 500
  });
  const onPanelWidthChange = (0, _react.useCallback)(newSizes => {
    setSizes(prevSizes => ({
      ...prevSizes,
      ...newSizes
    }));
  }, []);
  const {
    data,
    loading,
    error
  } = (0, _use_table_docs.useTableDocs)({
    dataView,
    range,
    sampleSize,
    name
  });
  const fieldSideBar = (0, _use_field_sidebar.useFieldSidebar)({
    dataView,
    columns,
    setColumns
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_search_bar.QuerySearchBar, (0, _extends2.default)({}, searchBarProps, {
    range: range,
    setRange: setRange,
    isFlyoutOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  })), error && !loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, error === null || error === void 0 ? void 0 : error.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    style: {
      height: 'calc(100vh - 300px)'
    },
    onPanelWidthChange: onPanelWidthChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, (EuiResizablePanel, EuiResizableButton) => {
    var _data$hits$hits, _data$hits;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: "fieldsPanel",
      size: sizes.fieldsPanel,
      minSize: "10%",
      tabIndex: 0,
      style: {
        paddingLeft: 0,
        paddingRight: 0
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, fieldSideBar), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
      indicator: "border",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: "documentsPanel",
      size: sizes.documentsPanel,
      minSize: "200px",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
      getTriggerCompatibleActions: services.uiActions.getTriggerCompatibleActions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 29
      }
    }), /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, {
      rows: (0, _discoverUtils.buildDataTableRecordList)({
        records: (_data$hits$hits = data === null || data === void 0 ? void 0 : (_data$hits = data.hits) === null || _data$hits === void 0 ? void 0 : _data$hits.hits) !== null && _data$hits$hits !== void 0 ? _data$hits$hits : [],
        dataView
      }),
      showColumnTokens: true,
      dataView: dataView,
      onFilter: (fieldK, val, mode) => {
        if (fieldK && typeof fieldK !== 'string' && 'name' in fieldK) {
          const dField = dataView.getFieldByName(fieldK === null || fieldK === void 0 ? void 0 : fieldK.name);
          if (!dField) {
            return;
          }
          const filterN = (0, _esQuery.buildFilter)(dataView, dField, _esQuery.FILTERS.PHRASE, mode === '-', false, val, null);
          if (_sloSchema.kqlQuerySchema.is(filter)) {
            setValue(name, {
              filters: [filterN],
              kqlQuery: filter
            });
          } else {
            setValue(name, {
              ...(filter !== null && filter !== void 0 ? filter : {}),
              filters: [filterN]
            });
          }
        }
      },
      services: {
        theme: services.theme,
        fieldFormats: services.fieldFormats,
        uiSettings: services.uiSettings,
        dataViewFieldEditor: services.dataViewFieldEditor,
        toastNotifications: services.notifications.toasts,
        storage: services.storage,
        data: services.data
      },
      ariaLabelledBy: _i18n.i18n.translate('xpack.slo.edit.documentsTableAriaLabel', {
        defaultMessage: 'Documents table'
      }),
      loadingState: loading ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded,
      columns: columns,
      onSetColumns: setColumns,
      showTimeCol: true,
      sampleSizeState: sampleSize,
      onUpdateSampleSize: nSample => {
        setSampleSize(nSample);
      },
      sort: [],
      showFullScreenButton: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    }))));
  }));
}