"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GoodBadEventsChart = GoodBadEventsChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _duration = require("../../../../utils/slo/duration");
var _get_discover_link = require("../../utils/get_discover_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/events_chart_panel/good_bad_events_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_INTERVAL = 10 * 60 * 1_000; // 10 minutes in milliseconds

function GoodBadEventsChart({
  data,
  slo,
  onBrushed
}) {
  const {
    charts,
    uiSettings,
    discover
  } = (0, _use_kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const {
    ObservabilityAnnotations,
    annotations,
    wrapOnBrushEnd,
    onAnnotationClick
  } = (0, _public2.useAnnotations)({
    slo
  });
  const dateFormat = uiSettings.get('dateFormat');
  const intervalInMilliseconds = data && data.length > 2 ? (0, _moment.default)(data[1].date).valueOf() - (0, _moment.default)(data[0].date).valueOf() : DEFAULT_INTERVAL;
  const goodEventId = _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.goodEventsLabel', {
    defaultMessage: 'Good events'
  });
  const badEventId = _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.badEventsLabel', {
    defaultMessage: 'Bad events'
  });
  const barClickHandler = params => {
    const [datum, eventDetail] = params[0];
    const isGoodEventClicked = eventDetail.specId === goodEventId;
    const isBadEventClicked = eventDetail.specId === badEventId;
    const timeRange = {
      from: (0, _moment.default)(datum.x).startOf('minute').toISOString(),
      to: (0, _moment.default)(datum.x).add(intervalInMilliseconds, 'ms').startOf('minute').toISOString(),
      mode: 'absolute'
    };
    (0, _get_discover_link.openInDiscover)({
      slo,
      showBad: isBadEventClicked,
      showGood: isGoodEventClicked,
      timeRange,
      discover,
      uiSettings
    });
  };
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200,
      width: '100%'
    },
    ref: chartRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAnnotations, {
    annotations: annotations,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: {
      chartMargins: {
        top: 30
      }
    },
    baseTheme: baseTheme,
    showLegend: true,
    legendPosition: _charts.Position.Left,
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: _i18n.i18n.translate('xpack.slo.goodBadEventsChart.euiIcon.noResultsLabel', {
        defaultMessage: 'no results'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale(),
    onElementClick: barClickHandler,
    onBrushEnd: wrapOnBrushEnd(brushArea => {
      onBrushed === null || onBrushed === void 0 ? void 0 : onBrushed((0, _duration.getBrushTimeBounds)(brushArea));
    }),
    onAnnotationClick: onAnnotationClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format('0'),
    domain: {
      fit: true,
      min: NaN,
      max: NaN
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: goodEventId,
    color: euiTheme.colors.success,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.success
      },
      displayValue: {
        fill: euiTheme.colors.success
      }
    }
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: data.map(datum => {
      var _datum$events;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events = datum.events) === null || _datum$events === void 0 ? void 0 : _datum$events.good
      };
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: badEventId,
    color: euiTheme.colors.danger,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.danger
      },
      displayValue: {
        fill: euiTheme.colors.danger
      }
    }
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: data.map(datum => {
      var _datum$events2;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events2 = datum.events) === null || _datum$events2 === void 0 ? void 0 : _datum$events2.bad
      };
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }));
}