"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkedDashboards = LinkedDashboards;
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/definition/linked_dashboards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDashboards = async (dashboardsIds, dashboardStart) => {
  if (dashboardsIds.length === 0) {
    return [];
  }
  const findDashboardsService = await dashboardStart.findDashboardsService();
  const dashboards = await findDashboardsService.findByIds(dashboardsIds);
  return dashboards.flatMap(dashboard => dashboard.status === 'success' ? [{
    id: dashboard.id,
    title: dashboard.attributes.title
  }] : []);
};
function LinkedDashboards({
  dashboards
}) {
  const {
    services: {
      share
    },
    services: {
      dashboard: dashboardStart
    }
  } = (0, _use_kibana.useKibana)();
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const dashboardsIds = (0, _react.useMemo)(() => dashboards.map(dashboard => dashboard.id), [dashboards]);
  const {
    data,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['SLO-dashboards', ...dashboardsIds],
    queryFn: () => getDashboards(dashboardsIds, dashboardStart),
    refetchOnWindowFocus: false
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  if (!data || data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.noDashboards', {
      defaultMessage: 'No linked dashboards'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, data.map(dashboardAsset => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: dashboardAsset.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "dashboardAssetLink",
      href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
        dashboardId: dashboardAsset.id
      }),
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }, dashboardAsset.title));
  }));
}