"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dependencies = Dependencies;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_fetch_slos_with_burn_rate_rules = require("../../hooks/use_fetch_slos_with_burn_rate_rules");
var _constants = require("../../../common/constants");
var _dependency_editor = require("./dependency_editor");
var _technical_preview_badge = require("../technical_preview_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/dependencies.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_GROUP_OPTIONS = [{
  value: _constants.ALERT_ACTION.id,
  label: _constants.ALERT_ACTION.name
}, {
  value: _constants.HIGH_PRIORITY_ACTION.id,
  label: _constants.HIGH_PRIORITY_ACTION.name
}, {
  value: _constants.MEDIUM_PRIORITY_ACTION.id,
  label: _constants.MEDIUM_PRIORITY_ACTION.name
}, {
  value: _constants.LOW_PRIORITY_ACTION.id,
  label: _constants.LOW_PRIORITY_ACTION.name
}];
function Dependencies({
  currentRuleId,
  dependencies,
  onChange
}) {
  const {
    isLoading,
    data: allRules
  } = (0, _use_fetch_slos_with_burn_rate_rules.useFetchSLOsWithBurnRateRules)({});
  const dependencyRuleIds = dependencies.map(dep => dep.ruleId);
  const availableRules = currentRuleId ? allRules === null || allRules === void 0 ? void 0 : allRules.filter(rule => rule.id !== currentRuleId && !dependencyRuleIds.includes(rule.id)) : allRules;
  const handleAddDependency = dependency => {
    onChange([...dependencies, dependency]);
  };
  const handleChange = (index, dependency) => {
    onChange(dependencies.map((dep, idx) => idx === index ? dependency : dep));
  };
  const handleDelete = index => {
    onChange(dependencies.filter((_dep, idx) => idx !== index));
  };
  const rows = dependencies.map((dependency, index) => {
    const rule = allRules === null || allRules === void 0 ? void 0 : allRules.find(({
      id
    }) => id === dependency.ruleId);
    return {
      index,
      name: rule === null || rule === void 0 ? void 0 : rule.name,
      actionGroupsToSuppressOn: dependency.actionGroupsToSuppressOn,
      dependency
    };
  });
  const columns = [{
    field: 'name',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.slo.rules.dependencies.ruleColumn', {
      defaultMessage: 'Rule'
    })
  }, {
    field: 'actionGroupsToSuppressOn',
    name: _i18n.i18n.translate('xpack.slo.rules.dependencies.supressOnColumn', {
      defaultMessage: 'Suppress on'
    }),
    render: groups => {
      return groups.map(group => {
        const actionGroup = ACTION_GROUP_OPTIONS.find(g => g.value === group);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 18
          }
        }, actionGroup === null || actionGroup === void 0 ? void 0 : actionGroup.label);
      });
    }
  }, {
    width: '50px',
    actions: [{
      render: row => {
        const handleSubmit = dep => {
          handleChange(row.index, dep);
        };
        const selectedRule = allRules === null || allRules === void 0 ? void 0 : allRules.find(({
          id
        }) => id === row.dependency.ruleId);
        return /*#__PURE__*/_react.default.createElement(_dependency_editor.DependencyEditor, {
          isLoading: isLoading,
          onSubmit: handleSubmit,
          dependency: row.dependency,
          rules: availableRules && selectedRule ? [...availableRules, selectedRule] : availableRules,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 15
          }
        });
      }
    }, {
      icon: 'trash',
      type: 'icon',
      color: 'danger',
      name: 'Delete',
      description: 'Delete dependency',
      onClick: row => {
        handleDelete(row.index);
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.slo.rules.dependencies.title', {
    defaultMessage: 'Rule dependencies'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.slo.rules.dependencies.description', {
    defaultMessage: 'Configure rule dependencies and designate the severity action groups you want to use to suppress the current rule. For instance, if you choose to suppress on the "Critical" and "High" action groups, the current rule will abstain from executing any actions of its severity groups when the associated rule dependency breaches its threshold. Instead, it will execute a "Suppressed" action group in response to the dependency trigger.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: rows,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_dependency_editor.DependencyEditor, {
    rules: availableRules,
    isLoading: isLoading,
    onSubmit: handleAddDependency,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }));
}