"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/core/public");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _plugin_context = require("./context/plugin_context");
var _use_plugin_context = require("./hooks/use_plugin_context");
var _routes = require("./routes/routes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const renderApp = ({
  core,
  plugins,
  appMountParameters,
  ObservabilityPageTemplate,
  usageCollection,
  isDev,
  kibanaVersion,
  isServerless,
  observabilityRuleTypeRegistry,
  experimentalFeatures,
  sloClient
}) => {
  var _usageCollection$comp, _plugins$cloud$CloudC, _plugins$cloud, _plugins$observabilit;
  const {
    element,
    history
  } = appMountParameters;

  // ensure all divs are .kbnAppWrappers
  element.classList.add(_public.APP_WRAPPER_CLASS);
  const queryClient = new _reactQuery.QueryClient();
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  const CloudProvider = (_plugins$cloud$CloudC = (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.CloudContextProvider) !== null && _plugins$cloud$CloudC !== void 0 ? _plugins$cloud$CloudC : _react.default.Fragment;
  const unregisterPrompts = (_plugins$observabilit = plugins.observabilityAIAssistant) === null || _plugins$observabilit === void 0 ? void 0 : _plugins$observabilit.service.setScreenContext({
    starterPrompts: [{
      title: _i18n.i18n.translate('xpack.slo.starterPrompts.whatAreSlos.title', {
        defaultMessage: 'Getting started'
      }),
      prompt: _i18n.i18n.translate('xpack.slo.starterPrompts.whatAreSlos.prompt', {
        defaultMessage: 'What are Service Level Objectives (SLOs)?'
      }),
      icon: 'bullseye'
    }, {
      title: _i18n.i18n.translate('xpack.slo.starterPrompts.canYouCreateAnSlo.title', {
        defaultMessage: 'Getting started'
      }),
      prompt: _i18n.i18n.translate('xpack.slo.starterPrompts.canYouCreateAnSlo.prompt', {
        defaultMessage: 'Can you create an SLO?'
      }),
      icon: 'question'
    }]
  });
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public3.Storage(localStorage),
      isDev,
      kibanaVersion,
      isServerless
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      isDev,
      isServerless,
      appMountParameters,
      ObservabilityPageTemplate,
      observabilityRuleTypeRegistry,
      experimentalFeatures,
      sloClient
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core,
    "data-test-subj": "observabilityMainContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(App, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 23
    }
  })))))))))), element);
  return () => {
    // This needs to be present to fix https://github.com/elastic/kibana/issues/155704
    // as the Overview page renders the UX Section component. That component renders a Lens embeddable
    // via the ExploratoryView app, which uses search sessions. Therefore on unmounting we need to clear
    // these sessions.
    plugins.data.search.session.clear();
    unregisterPrompts === null || unregisterPrompts === void 0 ? void 0 : unregisterPrompts();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
function App() {
  const {
    isServerless
  } = (0, _use_plugin_context.usePluginContext)();
  const routes = (0, _routes.getRoutes)(isServerless);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    enableExecutionContextTracking: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }, Object.keys(routes).map(path => {
    const {
      handler,
      exact
    } = routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 16
      }
    });
  }));
}