"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaErrorBoundary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _apmRum = require("@elastic/apm-rum");
var _react = _interopRequireDefault(require("react"));
var _lib = require("../../lib");
var _services = require("../services");
var _message_components = require("./message_components");
var _base_error_boundary = require("./base_error_boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/shared-ux/error_boundary/src/ui/error_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class ErrorBoundaryInternal extends _base_error_boundary.BaseErrorBoundary {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null,
      componentName: null,
      isFatal: null
    };
  }
  componentDidCatch(error, errorInfo) {
    _apmRum.apm.captureError(error, {
      labels: (0, _lib.getErrorBoundaryLabels)('PageFatalReactError')
    });
    console.error('Error caught by Kibana React Error Boundary'); // eslint-disable-line no-console
    console.error(error); // eslint-disable-line no-console

    // Enqueue the error instead of registering it immediately
    const enqueuedError = this.props.services.errorService.enqueueError(error, errorInfo);
    const {
      id: errorId,
      isFatal,
      name
    } = enqueuedError;
    this.setState({
      error,
      errorInfo,
      componentName: name,
      isFatal,
      errorId
    });
  }
  render() {
    if (this.state.error != null) {
      const {
        error,
        errorInfo,
        componentName,
        isFatal
      } = this.state;
      if (isFatal) {
        return /*#__PURE__*/_react.default.createElement(_message_components.FatalPrompt, {
          error: error,
          errorInfo: errorInfo,
          name: componentName,
          onClickRefresh: this.props.services.onClickRefresh,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 11
          }
        });
      } else {
        return /*#__PURE__*/_react.default.createElement(_message_components.RecoverablePrompt, {
          onClickRefresh: this.props.services.onClickRefresh,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 16
          }
        });
      }
    }

    // not in error state
    return this.props.children;
  }
}

/**
 * Implementation of Kibana Error Boundary
 * @param {ErrorBoundaryProps} props - ErrorBoundaryProps
 * @public
 */
const KibanaErrorBoundary = props => {
  const services = (0, _services.useErrorBoundary)();
  return /*#__PURE__*/_react.default.createElement(ErrorBoundaryInternal, (0, _extends2.default)({}, props, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  }));
};
exports.KibanaErrorBoundary = KibanaErrorBoundary;