"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelAlertListItem = exports.ALERT_LIST_ITEM_TIMESTAMP_TEST_ID = exports.ALERT_LIST_ITEM_TEST_ID = exports.ALERT_LIST_ITEM_FILE_PATH_TEST_ID = exports.ALERT_LIST_ITEM_ARGS_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _alert_icon_tooltip_content = require("../../../common/utils/alert_icon_tooltip_content");
var _constants = require("../../../common/constants");
var _styles = require("./styles");
var _detail_panel_alert_actions = require("../detail_panel_alert_actions");
var _data_or_dash = require("../../utils/data_or_dash");
var _hooks = require("../../hooks");
var _alert_category_display_text = require("../../utils/alert_category_display_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/detail_panel_alert_list_item/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ALERT_LIST_ITEM_TEST_ID = exports.ALERT_LIST_ITEM_TEST_ID = 'sessionView:detailPanelAlertListItem';
const ALERT_LIST_ITEM_ARGS_TEST_ID = exports.ALERT_LIST_ITEM_ARGS_TEST_ID = 'sessionView:detailPanelAlertListItemArgs';
const ALERT_LIST_ITEM_FILE_PATH_TEST_ID = exports.ALERT_LIST_ITEM_FILE_PATH_TEST_ID = 'sessionView:detailPanelAlertListItemFilePath';
const ALERT_LIST_ITEM_TIMESTAMP_TEST_ID = exports.ALERT_LIST_ITEM_TIMESTAMP_TEST_ID = 'sessionView:detailPanelAlertListItemTimestamp';
/**
 * Detail panel description list item.
 */
const DetailPanelAlertListItem = ({
  event,
  onJumpToEvent,
  onShowAlertDetails,
  isInvestigated,
  minimal
}) => {
  var _event$kibana, _event$kibana$alert, _event$process, _processEvent$categor;
  const styles = (0, _styles.useStyles)(minimal, isInvestigated);
  const dateFormat = (0, _hooks.useDateFormat)();
  if (!event.kibana) {
    return null;
  }
  const timestamp = (0, _eui.formatDate)(event['@timestamp'], dateFormat);
  const rule = (_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : (_event$kibana$alert = _event$kibana.alert) === null || _event$kibana$alert === void 0 ? void 0 : _event$kibana$alert.rule;
  const uuid = (rule === null || rule === void 0 ? void 0 : rule.uuid) || '';
  const name = (rule === null || rule === void 0 ? void 0 : rule.name) || '';
  const {
    args,
    name: processName
  } = (_event$process = event.process) !== null && _event$process !== void 0 ? _event$process : {};
  const {
    event: processEvent
  } = event;
  const forceState = !isInvestigated ? 'open' : undefined;
  const category = Array.isArray(processEvent === null || processEvent === void 0 ? void 0 : processEvent.category) ? processEvent === null || processEvent === void 0 ? void 0 : (_processEvent$categor = processEvent.category) === null || _processEvent$categor === void 0 ? void 0 : _processEvent$categor[0] : processEvent === null || processEvent === void 0 ? void 0 : processEvent.category;
  const processEventAlertCategory = category !== null && category !== void 0 ? category : 'process';
  const alertCategoryDetailDisplayText = category !== 'process' ? `${(0, _data_or_dash.dataOrDash)(processName)} ${(0, _alert_category_display_text.getAlertCategoryDisplayText)(event, category)}` : (0, _data_or_dash.dataOrDash)(args === null || args === void 0 ? void 0 : args.join(' '));
  const alertIconTooltipContent = (0, _alert_icon_tooltip_content.getAlertIconTooltipContent)(processEventAlertCategory);
  return minimal ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": ALERT_LIST_ITEM_TEST_ID,
    css: styles.firstAlertPad,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, (0, _data_or_dash.dataOrDash)(timestamp))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_detail_panel_alert_actions.DetailPanelAlertActions, {
    css: styles.minimalContextMenu,
    event: event,
    onJumpToEvent: onJumpToEvent,
    onShowAlertDetails: onShowAlertDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.processPanel,
    color: "subdued",
    hasBorder: true,
    hasShadow: false,
    borderRadius: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": ALERT_LIST_ITEM_ARGS_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, alertCategoryDetailDisplayText)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: styles.minimalHR,
    margin: "m",
    size: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: uuid,
    "data-test-subj": ALERT_LIST_ITEM_TEST_ID,
    arrowDisplay: isInvestigated ? 'right' : 'none',
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: styles.alertTitleContainer,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      css: styles.alertTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: alertIconTooltipContent,
      type: _constants.ALERT_ICONS[processEventAlertCategory],
      color: "danger",
      css: styles.alertIcon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }), (0, _data_or_dash.dataOrDash)(name))),
    initialIsOpen: true,
    forceState: forceState,
    css: styles.alertItem,
    extraAction: /*#__PURE__*/_react.default.createElement(_detail_panel_alert_actions.DetailPanelAlertActions, {
      event: event,
      onJumpToEvent: onJumpToEvent,
      onShowAlertDetails: onShowAlertDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": ALERT_LIST_ITEM_TIMESTAMP_TEST_ID,
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, (0, _data_or_dash.dataOrDash)(timestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.processPanel,
    color: "subdued",
    hasBorder: true,
    hasShadow: false,
    borderRadius: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": ALERT_LIST_ITEM_ARGS_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, alertCategoryDetailDisplayText)), isInvestigated && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.investigatedLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.detailPanelAlertListItem.investigatedLabel",
    defaultMessage: "Investigated alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }))));
};
exports.DetailPanelAlertListItem = DetailPanelAlertListItem;