"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _searchApiPanels = require("@kbn/search-api-panels");
var _self_managed_connectors_empty_prompt = require("./connectors/self_managed_connectors_empty_prompt");
var _doc_links = require("../../../common/doc_links");
var _i18n_string = require("../../../common/i18n_string");
var _use_connectors = require("../hooks/api/use_connectors");
var _use_create_connector = require("../hooks/api/use_create_connector");
var _use_kibana = require("../hooks/use_kibana");
var _connectors_table = require("./connectors/connectors_table");
var _connector_privileges_callout = require("./connectors/connector_config/connector_privileges_callout");
var _use_asset_base_path = require("../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/serverless_search/public/application/components/connectors_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorsOverview = () => {
  const {
    data,
    isLoading: connectorsLoading
  } = (0, _use_connectors.useConnectors)();
  const {
    console: consolePlugin
  } = (0, _use_kibana.useKibanaServices)();
  const {
    createConnector,
    isLoading
  } = (0, _use_create_connector.useCreateConnector)();
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  const canManageConnectors = !data || data.canManageConnectors;
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchConnectorsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: _i18n.i18n.translate('xpack.serverlessSearch.connectors.title', {
      defaultMessage: 'Connectors'
    }),
    "data-test-subj": "serverlessSearchConnectorsTitle",
    restrictWidth: true,
    rightSideItems: connectorsLoading || ((data === null || data === void 0 ? void 0 : data.connectors) || []).length > 0 ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.GithubLink, {
      href: 'https://github.com/elastic/connectors',
      label: _i18n.i18n.translate('xpack.serverlessSearch.connectorsPythonLink', {
        defaultMessage: 'elastic/connectors'
      }),
      assetBasePath: assetBasePath,
      "data-test-subj": "serverlessSearchConnectorsOverviewElasticConnectorsLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "serverlessSearchConnectorsOverviewCreateConnectorButton",
      disabled: !canManageConnectors,
      isLoading: isLoading,
      fill: true,
      iconType: "plusInCircleFilled",
      onClick: () => createConnector(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.createConnector', {
      defaultMessage: 'Create connector'
    }))))] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.connectors.headerContent",
    defaultMessage: "Sync third-party data sources to Elasticsearch, by deploying Elastic connectors on your own infrastructure. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "serverlessSearchConnectorsOverviewLink",
        target: "_blank",
        href: _doc_links.docLinks.connectors,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 19
        }
      }, _i18n_string.LEARN_MORE_LABEL)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    restrictWidth: true,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_privileges_callout.ConnectorPrivilegesCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), connectorsLoading || ((data === null || data === void 0 ? void 0 : data.connectors) || []).length > 0 ? /*#__PURE__*/_react.default.createElement(_connectors_table.ConnectorsTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_self_managed_connectors_empty_prompt.SelfManagedConnectorsEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), embeddableConsole);
};
exports.ConnectorsOverview = ConnectorsOverview;