"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateAndPersistRiskScores = void 0;
var _calculate_risk_scores = require("./calculate_risk_scores");
var _calculate_esql_risk_scores = require("./calculate_esql_risk_scores");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateAndPersistRiskScores = async params => {
  var _scores$host, _scores$user, _scores$service, _scores$generic, _scores$host2, _scores$user2, _scores$service2;
  const {
    riskScoreDataClient,
    spaceId,
    returnScores,
    refresh,
    ...rest
  } = params;
  const writer = await riskScoreDataClient.getWriter({
    namespace: spaceId
  });
  const calculate = params.experimentalFeatures.disableESQLRiskScoring ? _calculate_risk_scores.calculateRiskScores : _calculate_esql_risk_scores.calculateScoresWithESQL;
  const {
    after_keys: afterKeys,
    scores
  } = await calculate(rest);

  // Extract entity IDs from scores for reset-to-zero functionality
  const entities = {
    host: ((_scores$host = scores.host) === null || _scores$host === void 0 ? void 0 : _scores$host.map(score => score.id_value)) || [],
    user: ((_scores$user = scores.user) === null || _scores$user === void 0 ? void 0 : _scores$user.map(score => score.id_value)) || [],
    service: ((_scores$service = scores.service) === null || _scores$service === void 0 ? void 0 : _scores$service.map(score => score.id_value)) || [],
    generic: ((_scores$generic = scores.generic) === null || _scores$generic === void 0 ? void 0 : _scores$generic.map(score => score.id_value)) || []
  };
  if (!((_scores$host2 = scores.host) !== null && _scores$host2 !== void 0 && _scores$host2.length) && !((_scores$user2 = scores.user) !== null && _scores$user2 !== void 0 && _scores$user2.length) && !((_scores$service2 = scores.service) !== null && _scores$service2 !== void 0 && _scores$service2.length)) {
    return {
      after_keys: {},
      errors: [],
      scores_written: 0,
      entities
    };
  }
  try {
    await riskScoreDataClient.upgradeIfNeeded();
  } catch (err) {
    params.logger.error(`There was an error upgrading the risk score indices. Continuing with risk score persistence. ${err.message}`);
  }
  const {
    errors,
    docs_written: scoresWritten
  } = await writer.bulk({
    ...scores,
    refresh
  });
  const result = {
    after_keys: afterKeys,
    errors,
    scores_written: scoresWritten,
    entities
  };
  return returnScores ? {
    ...result,
    scores
  } : result;
};
exports.calculateAndPersistRiskScores = calculateAndPersistRiskScores;