"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osqueryResponseAction = void 0;
var _lodash = require("lodash");
var _replace_params_query = require("@kbn/osquery-plugin/common/utils/replace_params_query");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const osqueryResponseAction = (responseAction, osqueryCreateActionService, endpointAppContextService, {
  alerts
}) => {
  var _responseAction$param, _alerts$, _alerts$$kibana, _alerts$$kibana$space;
  const logger = osqueryCreateActionService.logger;
  const temporaryQueries = (_responseAction$param = responseAction.params.queries) !== null && _responseAction$param !== void 0 && _responseAction$param.length ? responseAction.params.queries : [{
    query: responseAction.params.query
  }];
  const containsDynamicQueries = (0, _lodash.some)(temporaryQueries, query => query.query && (0, _replace_params_query.containsDynamicQuery)(query.query));
  const {
    savedQueryId,
    packId,
    queries,
    ecsMapping,
    ...rest
  } = responseAction.params;
  // Extract space information from the first alert (all alerts should be from the same space)
  const spaceId = (_alerts$ = alerts[0]) === null || _alerts$ === void 0 ? void 0 : (_alerts$$kibana = _alerts$.kibana) === null || _alerts$$kibana === void 0 ? void 0 : (_alerts$$kibana$space = _alerts$$kibana.space_ids) === null || _alerts$$kibana$space === void 0 ? void 0 : _alerts$$kibana$space[0];
  const processResponseActionClientError = (err, endpointIds) => {
    logger.error(`attempt to run osquery queries on host IDs [${endpointIds.join(', ')}] returned error: ${err.message}`);
    return Promise.resolve();
  };
  if (!spaceId) {
    var _alerts$0$kibana$aler, _alerts$0$kibana$aler2;
    const ruleId = (_alerts$0$kibana$aler = alerts[0].kibana.alert) === null || _alerts$0$kibana$aler === void 0 ? void 0 : _alerts$0$kibana$aler.rule.uuid;
    const ruleName = (_alerts$0$kibana$aler2 = alerts[0].kibana.alert) === null || _alerts$0$kibana$aler2 === void 0 ? void 0 : _alerts$0$kibana$aler2.rule.name;
    logger.error(`Unable to identify the space ID from alert data ('kibana.space_ids') for rule [${ruleName}][${ruleId}]`);
    return;
  }
  if (!containsDynamicQueries) {
    const agentIds = (0, _lodash.uniq)((0, _lodash.map)(alerts, 'agent.id'));
    const alertIds = (0, _lodash.map)(alerts, '_id');
    return osqueryCreateActionService.create({
      ...rest,
      queries: (0, _zodHelpers.requiredOptional)(queries),
      ecs_mapping: ecsMapping,
      saved_query_id: savedQueryId,
      agent_ids: agentIds,
      alert_ids: alertIds
    }, {
      space: {
        id: spaceId
      }
    }).catch(err => {
      return processResponseActionClientError(err, agentIds);
    });
  }
  (0, _lodash.each)(alerts, alert => {
    var _alert$agent;
    const agentIds = (_alert$agent = alert.agent) !== null && _alert$agent !== void 0 && _alert$agent.id ? [alert.agent.id] : [];
    return osqueryCreateActionService.create({
      ...rest,
      queries: (0, _zodHelpers.requiredOptional)(queries),
      ecs_mapping: ecsMapping,
      saved_query_id: savedQueryId,
      agent_ids: agentIds,
      alert_ids: [alert._id]
    }, {
      alertData: alert,
      space: {
        id: spaceId
      }
    }).catch(err => {
      return processResponseActionClientError(err, agentIds);
    });
  });
};
exports.osqueryResponseAction = osqueryResponseAction;