"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptsFileMetadataIndexTemplate = exports.ScriptsFileDataIndexTemplate = void 0;
var _std = require("@kbn/std");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Index template for storing File metadata. Index is used mainly with the Files plugin
 * to manage files associated with Elastic Defend Scripts library entries
 */
const ScriptsFileMetadataIndexTemplate = exports.ScriptsFileMetadataIndexTemplate = (0, _std.deepFreeze)({
  name: _constants.SCRIPTS_LIBRARY_FILE_METADATA_INDEX_NAME_PREFIX,
  index_patterns: [`${_constants.SCRIPTS_LIBRARY_FILE_METADATA_INDEX_NAME_PREFIX}-*`],
  priority: 500,
  allow_auto_create: true,
  _meta: {
    description: 'Index template for Elastic Defend scripts library storage of file metadata',
    managed: true
  },
  template: {
    settings: {
      'index.auto_expand_replicas': '0-1',
      'index.hidden': true
    },
    mappings: {
      dynamic: false,
      properties: {
        file: {
          properties: {
            Status: {
              type: 'keyword'
            },
            ChunkSize: {
              type: 'integer'
            },
            Compression: {
              type: 'keyword'
            },
            name: {
              type: 'keyword'
            },
            Meta: {
              properties: {
                script_id: {
                  type: 'keyword'
                }
              }
            }
          }
        }
      }
    }
  }
});

/**
 * Index template for storing File data content. Index is used mainly with the Files plugin
 * to manage files associated with Elastic Defend Scripts library entries
 */
const ScriptsFileDataIndexTemplate = exports.ScriptsFileDataIndexTemplate = (0, _std.deepFreeze)({
  name: _constants.SCRIPTS_LIBRARY_FILE_DATA_INDEX_NAME_PREFIX,
  index_patterns: [`${_constants.SCRIPTS_LIBRARY_FILE_DATA_INDEX_NAME_PREFIX}-*`],
  priority: 500,
  allow_auto_create: true,
  _meta: {
    description: 'Index template for Elastic Defend scripts library storage of file data content',
    managed: true
  },
  template: {
    settings: {
      'index.auto_expand_replicas': '0-1',
      'index.hidden': true
    },
    mappings: {
      dynamic: false,
      properties: {
        data: {
          type: 'binary',
          store: true
        },
        bid: {
          type: 'keyword'
        },
        sha2: {
          type: 'keyword',
          index: false
        },
        last: {
          type: 'boolean',
          index: false
        }
      }
    }
  }
});