"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.referenceDataSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const referenceDataAttributesSchemaV1 = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  owner: _configSchema.schema.string(),
  metadata: _configSchema.schema.maybe(_configSchema.schema.any())
});
const referenceDataSavedObjectType = exports.referenceDataSavedObjectType = {
  name: _constants.REFERENCE_DATA_SAVED_OBJECT_TYPE,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  namespaceType: 'agnostic',
  hidden: true,
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      type: {
        type: 'keyword'
      },
      owner: {
        type: 'keyword'
      }
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: referenceDataAttributesSchemaV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: referenceDataAttributesSchemaV1
      }
    }
  }
};