"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetAlertsById = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetAlertsById = ({
  esClient
}) => async ({
  index,
  ids,
  anonymizationFields
}) => {
  const query = buildAlertsByIdQuery(ids, index, anonymizationFields);
  const response = await esClient.search(query);
  return response.hits.hits.reduce((acc, hit) => {
    if (hit.fields && hit._id) {
      acc[hit._id] = hit.fields;
    }
    return acc;
  }, {});
};
exports.createGetAlertsById = createGetAlertsById;
const buildAlertsByIdQuery = (ids, index, anonymizationFields) => {
  const filter = [{
    terms: {
      _id: ids
    }
  }];
  return {
    index,
    ignore_unavailable: true,
    size: ids.length,
    from: 0,
    query: {
      bool: {
        filter
      }
    },
    allow_no_indices: true,
    _source: false,
    fields: anonymizationFields.filter(fieldItem => fieldItem.allowed).map(fieldItem => ({
      field: fieldItem.field,
      include_unmapped: true
    }))
  };
};