"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineWrapper = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _modal = require("../components/modal");
var _use_selector = require("../../common/hooks/use_selector");
var _bottom_bar = require("../components/bottom_bar");
var _selectors = require("../store/selectors");
var _use_timeline_save_prompt = require("../../common/hooks/timeline/use_timeline_save_prompt");
var _store = require("../store");
var _use_which_flyout = require("../../flyout/document_details/shared/hooks/use_which_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/wrapper/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component renders the timeline EuiPortal as well as the bottom bar, and handles the interaction between the two.
 * Using EuiFocusTrap, we can trap the focus within the portal when it is open, which prevents closing the portal when clicking outside of it.
 */
const TimelineWrapper = exports.TimelineWrapper = /*#__PURE__*/_react.default.memo(({
  timelineId,
  onAppLeave
}) => {
  const getTimelineShowStatus = (0, _react.useMemo)(() => (0, _selectors.getTimelineShowStatusByIdSelector)(), []);
  const {
    show
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineShowStatus(state, timelineId));
  const dispatch = (0, _reactRedux.useDispatch)();
  const openToggleRef = (0, _react.useRef)(null);
  const handleClose = (0, _react.useCallback)(() => {
    dispatch(_store.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
  }, [dispatch, timelineId]);
  const {
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();

  // pressing the ESC key closes the timeline portal unless a flyout is opened on top of it
  const onKeyDown = (0, _react.useCallback)(ev => {
    if (ev.key === _eui.keys.ESCAPE) {
      const query = new URLSearchParams(window.location.search);
      const timelineFlyoutOpen = (0, _use_which_flyout.isTimelineFlyoutOpen)(query);
      if (timelineFlyoutOpen) {
        closeFlyout();
        return;
      }
      handleClose();
    }
  }, [closeFlyout, handleClose]);
  (0, _use_timeline_save_prompt.useTimelineSavePrompt)(timelineId, onAppLeave);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !show,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_modal.TimelineModal, {
    timelineId: timelineId,
    visible: show,
    openToggleRef: openToggleRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_bottom_bar.TimelineBottomBar, {
    show: show,
    timelineId: timelineId,
    openToggleRef: openToggleRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }));
});
TimelineWrapper.displayName = 'TimelineWrapper';