"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimelineDataGridBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react2 = require("@emotion/react");
var _reactWindow = require("react-window");
var _eui = require("@elastic/eui");
var _constants = require("../../body/constants");
var _use_stateful_row_renderer = require("../../body/events/stateful_row_renderer/use_stateful_row_renderer");
var _get_event_type_row_classname = require("./get_event_type_row_classname");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/unified_components/data_table/custom_timeline_data_grid_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultAutoHeight = {
  defaultHeight: 'auto'
};
const VirtualizedCustomDataGridContainer = _styledComponents.default.div`
  width: 100%;
  height: 100%;
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  .udt--customRow {
    border-radius: 0;
    padding: ${props => props.theme.eui.euiDataGridCellPaddingM};
    max-width: ${props => props.$maxWidth}px;
  }

 .euiDataGridRowCell--lastColumn.euiDataGridRowCell--controlColumn  .euiDataGridRowCell__content {
    width: ${props => props.$maxWidth}px;
    max-width: ${props => props.$maxWidth}px;
    overflow-x: auto;
    scrollbar-width: thin;
    scroll-padding: 0 0 0 0,
  }

   .euiDataGridRow:has(.unifiedDataTable__cell--expanded) {
      .euiDataGridRowCell--firstColumn,
      .euiDataGridRowCell--lastColumn,
      .euiDataGridRowCell--controlColumn,
      .udt--customRow {
        ${({
  theme
}) => `background-color: ${theme.eui.euiColorHighlight};`}
      }
    }
  }
`;

// THE DataGrid Row default is 34px, but we make ours 40 to account for our row actions
const DEFAULT_UDT_ROW_HEIGHT = 34;

/**
 *
 * In order to render the additional row with every event ( which displays the row-renderer, notes and notes editor)
 * we need to pass a way for EuiDataGrid to render the whole grid body via a custom component
 *
 * This component is responsible for styling and accessibility of the custom designed cells.
 *
 * In our case, we need TimelineExpandedRow ( technicall a data grid column which spans the whole width of the data grid)
 * component to be shown as an addendum to the normal event row. As mentioned above, it displays the row-renderer, notes and notes editor
 *
 * Ref: https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer
 *
 * */
const CustomTimelineDataGridBody = exports.CustomTimelineDataGridBody = /*#__PURE__*/(0, _react.memo)(function CustomTimelineDataGridBody(props) {
  const {
    Cell,
    visibleColumns,
    visibleRowData,
    rows,
    rowHeight,
    enabledRowRenderers,
    refetch,
    setCustomGridBodyProps,
    headerRow,
    footerRow,
    gridWidth
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // // Set custom props onto the grid body wrapper
  const bodyRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setCustomGridBodyProps({
      ref: bodyRef,
      style: {
        width: '100%',
        height: '100%',
        overflowY: 'hidden',
        scrollbarColor: `${euiTheme.colors.mediumShade} ${euiTheme.colors.lightestShade}`
      }
    });
  }, [setCustomGridBodyProps, euiTheme.colors.mediumShade, euiTheme.colors.lightestShade]);
  const visibleRows = (0, _react.useMemo)(() => (rows !== null && rows !== void 0 ? rows : []).slice(visibleRowData.startRow, visibleRowData.endRow), [rows, visibleRowData]);
  const listRef = (0, _react.useRef)(null);
  const rowHeights = (0, _react.useRef)([]);
  const setRowHeight = (0, _react.useCallback)((index, height) => {
    var _listRef$current;
    if (rowHeights.current[index] === height) return;
    (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.resetAfterIndex(index);
    rowHeights.current[index] = height;
  }, []);
  const getRowHeight = (0, _react.useCallback)(index => {
    var _rowHeights$current$i;
    return (_rowHeights$current$i = rowHeights.current[index]) !== null && _rowHeights$current$i !== void 0 ? _rowHeights$current$i : 100;
  }, []);

  /*
   *
   * There is a difference between calculatedWidth & gridWidth
   *
   * gridWidth is the width of the grid as per the screen size
   *
   * calculatedWidth is the width of the grid that is calculated by EUI and represents
   * the actual width of the grid based on the content of the grid. ( Sum of the width of all columns)
   *
   * For example, screensize can be variable but calculatedWidth can be much more than that
   * with grid having a horizontal scrollbar
   *
   *
   * */
  const [calculatedWidth, setCalculatedWidth] = (0, _react.useState)(gridWidth);
  (0, _react.useEffect)(() => {
    var _bodyRef$current;
    /*
     * Any time gridWidth(available screen size) is changed, we need to re-check
     * to see if EUI has changed the width of the grid
     *
     */
    if (!bodyRef) return;
    const headerRowRef = bodyRef === null || bodyRef === void 0 ? void 0 : (_bodyRef$current = bodyRef.current) === null || _bodyRef$current === void 0 ? void 0 : _bodyRef$current.querySelector('.euiDataGridHeader[role="row"]');
    setCalculatedWidth(prev => headerRowRef !== null && headerRowRef !== void 0 && headerRowRef.clientWidth && (headerRowRef === null || headerRowRef === void 0 ? void 0 : headerRowRef.clientWidth) !== prev ? headerRowRef === null || headerRowRef === void 0 ? void 0 : headerRowRef.clientWidth : prev);
  }, [gridWidth]);
  const innerRowContainer = (0, _react.useMemo)(() => {
    const InnerComp = /*#__PURE__*/_react.default.forwardRef(({
      children,
      style,
      ...rest
    }, ref) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, headerRow, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: "custom__grid__rows--container",
        "data-test-subj": "customGridRowsContainer",
        ref: ref,
        style: style,
        css: {
          position: 'relative'
        }
      }, rest, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 13
        }
      }), children), footerRow);
    });
    InnerComp.displayName = 'InnerRowContainer';
    return /*#__PURE__*/_react.default.memo(InnerComp);
  }, [headerRow, footerRow]);
  return /*#__PURE__*/_react.default.createElement(VirtualizedCustomDataGridContainer, {
    $maxWidth: calculatedWidth,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    className: "autosizer",
    disableWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, ({
    height
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
    /**
     * whenever timeline is minimized, VariableList is re-rendered which causes delay,
     * so below code makes sure that grid is only rendered when gridWidth is not 0
     */
    gridWidth !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, {
      className: "variable__list"
      /* available space on the screen */,
      width: gridWidth,
      height: height,
      itemCount: visibleRows.length,
      itemSize: getRowHeight,
      overscanCount: 5,
      ref: listRef,
      css: (0, _react2.css)`
                          scrollbar-width: thin;
                          scroll-padding: 0 0 0 0;
                          overflow: auto;
                        `,
      innerElementType: innerRowContainer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 23
      }
    }, ({
      index,
      style
    }) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        role: "row",
        style: style,
        css: {
          width: 'fit-content'
        },
        key: `${gridWidth}-${index}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(CustomDataGridSingleRow, {
        rowData: visibleRows[index],
        rowIndex: index,
        visibleColumns: visibleColumns,
        Cell: Cell,
        enabledRowRenderers: enabledRowRenderers,
        refetch: refetch,
        setRowHeight: setRowHeight,
        rowHeight: rowHeight,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 31
        }
      }));
    })));
  }));
});

/**
 *
 * A Simple Wrapper component for displaying a custom grid row
 * Generating CSS on this row puts a huge performance overhead on the grid as each row much styled individually.
 * If possible, try to use the styles either in ../styles.tsx or in the parent component
 *
 */

const CustomGridRow = _styledComponents.default.div.attrs(props => {
  var _props$className;
  return {
    className: `euiDataGridRow ${(_props$className = props.className) !== null && _props$className !== void 0 ? _props$className : ''}`,
    role: 'row'
  };
})``;

/* below styles as per : https://eui.elastic.co/#/tabular-content/data-grid-advanced#custom-body-renderer */
const CustomGridRowCellWrapper = _styledComponents.default.div.attrs(props => {
  var _props$className2;
  return {
    className: `rowCellWrapper ${(_props$className2 = props.className) !== null && _props$className2 !== void 0 ? _props$className2 : ''}`,
    role: 'row'
  };
})`
  height: ${props => props.$cssRowHeight};
  .euiDataGridRowCell,
  .euiDataGridRowCell__content {
    min-height: ${DEFAULT_UDT_ROW_HEIGHT}px;
  }
`;
const calculateRowHeightInPixels = lineHeightMultiple => {
  // The line height multiple can be negative to indicate "auto" in the unified data table
  if (lineHeightMultiple < 0) return 'auto';
  // The base line-height in pixels is 16px. This would be calculated default by the datagird and we could use
  // the `configRowHeight` prop, but since we own control of our rows via `customGridBody` we have to calculate it ourselves.
  const baseRowLineHeightInPx = 16;
  const rowHeightInPixels = DEFAULT_UDT_ROW_HEIGHT + baseRowLineHeightInPx * lineHeightMultiple;
  return `${rowHeightInPixels}px`;
};

/**
 *
 * RenderCustomBody component above uses this component to display a single row.
 *
 * */
const CustomDataGridSingleRow = /*#__PURE__*/(0, _react.memo)(function CustomDataGridSingleRow(props) {
  const {
    rowIndex,
    rowData,
    enabledRowRenderers,
    visibleColumns,
    Cell,
    rowHeight: rowHeightMultiple = 0,
    setRowHeight
  } = props;
  const {
    canShowRowRenderer
  } = (0, _use_stateful_row_renderer.useStatefulRowRenderer)({
    data: rowData.ecs,
    rowRenderers: enabledRowRenderers
  });
  const rowRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (rowRef.current) {
      setRowHeight(rowIndex, rowRef.current.offsetHeight);
    }
  }, [rowIndex, setRowHeight]);
  const cssRowHeight = calculateRowHeightInPixels(rowHeightMultiple - 1);

  /**
   * removes the border between the actual row ( timelineEvent) and `TimelineEventDetail` row
   * which renders the row-renderer, notes and notes editor
   *
   */
  const cellCustomStyle = (0, _react.useMemo)(() => canShowRowRenderer ? {
    borderBottom: 'none'
  } : {}, [canShowRowRenderer]);
  const eventTypeRowClassName = (0, _react.useMemo)(() => (0, _get_event_type_row_classname.getEventTypeRowClassName)(rowData.ecs), [rowData.ecs]);
  return /*#__PURE__*/_react.default.createElement(CustomGridRow, {
    className: `${rowIndex % 2 !== 0 ? 'euiDataGridRow--striped' : ''}`,
    key: rowIndex,
    ref: rowRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CustomGridRowCellWrapper, {
    className: eventTypeRowClassName,
    $cssRowHeight: cssRowHeight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 7
    }
  }, visibleColumns.map((column, colIndex) => {
    if (column.id !== _constants.TIMELINE_EVENT_DETAIL_ROW_ID) {
      return /*#__PURE__*/_react.default.createElement(Cell, {
        style: cellCustomStyle,
        colIndex: colIndex,
        visibleRowIndex: rowIndex,
        key: `${rowIndex},${colIndex}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 363,
          columnNumber: 15
        }
      });
    }
    return null;
  })), canShowRowRenderer ? /*#__PURE__*/_react.default.createElement(Cell, {
    rowHeightsOptions: defaultAutoHeight
    /* @ts-expect-error because currently CellProps do not allow string width but it is important to be passed for height calculations   */,
    width: '100%',
    colIndex: visibleColumns.length - 1 // If the row is being shown, it should always be the last index
    ,
    visibleRowIndex: rowIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 9
    }
  }) : null);
});