"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineControlColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _use_license = require("../../../../../common/hooks/use_license");
var _control_columns = require("../../body/control_columns");
var _control_column_cell_render = require("../../unified_components/data_table/control_column_cell_render");
var _use_timeline_unified_data_table_context = require("../../unified_components/data_table/use_timeline_unified_data_table_context");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/shared/use_timeline_control_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useTimelineControlColumn = ({
  timelineId,
  refetch,
  events,
  eventIdToNoteIds,
  onToggleShowNotes
}) => {
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = (0, _react.useMemo)(() => isEnterprisePlus ? 5 : 4, [isEnterprisePlus]);
  const {
    notesPrivileges: {
      read: canReadNotes
    },
    timelinePrivileges: {
      crud: canWriteTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const RowCellRender = (0, _react.useMemo)(() => function TimelineControlColumnCellRenderer(props) {
    var _events$props$rowInde2;
    const ctx = (0, _use_timeline_unified_data_table_context.useTimelineUnifiedDataTableContext)();
    (0, _react.useEffect)(() => {
      var _ctx$expanded, _events$props$rowInde;
      props.setCellProps({
        className: ((_ctx$expanded = ctx.expanded) === null || _ctx$expanded === void 0 ? void 0 : _ctx$expanded.id) === ((_events$props$rowInde = events[props.rowIndex]) === null || _events$props$rowInde === void 0 ? void 0 : _events$props$rowInde._id) ? 'unifiedDataTable__cell--expanded' : ''
      });
    });

    /*
     * In some cases, when number of events is updated
     * but new table is not yet rendered it can result
     * in the mismatch between the number of events v/s
     * the number of rows in the table currently rendered.
     *
     * */
    if ('rowIndex' in props && props.rowIndex >= events.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_control_column_cell_render.TimelineControlColumnCellRender, {
      ariaRowindex: props.rowIndex,
      columnValues: "",
      disablePinAction: !canWriteTimelines,
      ecsData: events[props.rowIndex].ecs,
      eventId: (_events$props$rowInde2 = events[props.rowIndex]) === null || _events$props$rowInde2 === void 0 ? void 0 : _events$props$rowInde2._id,
      eventIdToNoteIds: eventIdToNoteIds,
      refetch: refetch,
      showNotes: canReadNotes,
      timelineId: timelineId,
      toggleShowNotes: onToggleShowNotes,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    });
  }, [canReadNotes, canWriteTimelines, eventIdToNoteIds, events, onToggleShowNotes, refetch, timelineId]);
  return (0, _react.useMemo)(() => {
    return (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT).map(x => ({
      ...x,
      rowCellRender: _constants.JEST_ENVIRONMENT ? RowCellRender : /*#__PURE__*/_react.default.memo(RowCellRender)
    }));
  }, [ACTION_BUTTON_COUNT, RowCellRender]);
};
exports.useTimelineControlColumn = useTimelineControlColumn;