"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _process_execution_malware_prevention_alert = require("../../../../common/demo_data/endpoint/process_execution_malware_prevention_alert");
var _generic_row_renderer = require("../../timeline/body/renderers/system/generic_row_renderer");
var _translations = require("../../timeline/body/renderers/system/translations");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsExampleComponent = () => {
  const alertsRowRenderer = (0, _generic_row_renderer.createEndpointAlertsRowRenderer)({
    eventAction: 'execution',
    eventCategory: 'process',
    eventType: 'denied',
    skipRedundantFileDetails: true,
    text: _translations.WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertsRowRenderer.renderRow({
    data: _process_execution_malware_prevention_alert.demoEndpointProcessExecutionMalwarePreventionAlert,
    scopeId: _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID
  }));
};
const AlertsExample = exports.AlertsExample = /*#__PURE__*/_react.default.memo(AlertsExampleComponent);