"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterIntegrations = exports.THREAT_INTELLIGENCE_UTILITIES = exports.THREAT_INTELLIGENCE_CATEGORY = exports.INSTALLATION_STATUS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALLATION_STATUS = exports.INSTALLATION_STATUS = {
  Installed: 'installed',
  Installing: 'installing',
  InstallFailed: 'install_failed',
  NotInstalled: 'not_installed'
};
const THREAT_INTELLIGENCE_CATEGORY = exports.THREAT_INTELLIGENCE_CATEGORY = 'threat_intel';
const THREAT_INTELLIGENCE_UTILITIES = exports.THREAT_INTELLIGENCE_UTILITIES = 'ti_util';

/**
 * Filter an array of integrations:
 * - of status `installed`
 * - with `threat_intel` category
 * - excluding `ti_util` integration
 *
 * For more details see https://github.com/elastic/security-team/issues/4374
 *
 * @param integrations the response from the packages endpoint in the Fleet plugin
 */
const filterIntegrations = integrations => integrations.filter(
// eslint-disable-next-line @typescript-eslint/no-explicit-any
pkg => pkg.status === INSTALLATION_STATUS.Installed && pkg.categories.find(category => category === THREAT_INTELLIGENCE_CATEGORY) != null && pkg.id !== THREAT_INTELLIGENCE_UTILITIES);
exports.filterIntegrations = filterIntegrations;