"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDataProvider = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate a DataProvider object to use when adding/investigating to/in a timeline.
 * @param field used to generate the DataProvider id as well as its queryMatch
 * @param value used to generate the DataProvider id as well as its name and queryMatch
 */
const generateDataProvider = (field, value) => {
  const operator = ':';
  const id = `timeline-indicator-${field}-${value}`;
  return {
    and: [],
    enabled: true,
    id,
    name: value,
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field,
      value,
      operator
    }
  };
};
exports.generateDataProvider = generateDataProvider;