"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cellRendererFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styles = require("./styles");
var _field_value = require("../common/field_value");
var _use_table_context = require("../../hooks/use_table_context");
var _actions_row_cell = require("./actions_row_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/table/cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable react/display-name */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const cellRendererFactory = from => {
  return ({
    rowIndex,
    columnId,
    setCellProps
  }) => {
    const styles = (0, _styles.useStyles)();
    const indicatorsTableContext = (0, _react.useContext)(_use_table_context.IndicatorsTableContext);
    if (!indicatorsTableContext) {
      throw new Error('this can only be used inside indicators table');
    }
    const {
      indicators
    } = indicatorsTableContext;
    const indicator = indicators[rowIndex - from];
    if (!indicator) {
      return null;
    }
    const renderContent = columnId === 'Actions' ? /*#__PURE__*/_react.default.createElement(_actions_row_cell.ActionsRowCell, {
      indicator: indicator,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement(_field_value.IndicatorFieldValue, {
      indicator: indicator,
      field: columnId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.tableCell,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    }, renderContent);
  };
};
exports.cellRendererFactory = cellRendererFactory;