"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionsColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _links = require("../../../../common/components/links");
var _constants = require("../../../../../common/siem_migrations/constants");
var _link_to = require("../../../../common/components/link_to");
var _common = require("../../../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table_columns/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionName = ({
  disableActions,
  migrationRule,
  openMigrationRuleDetails,
  installMigrationRule
}) => {
  var _migrationRule$elasti;
  // Failed
  if (migrationRule.status === _constants.SiemMigrationStatus.FAILED) {
    return null;
  }

  // Installed
  if ((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id) {
    return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
      deepLinkId: _common.SecurityPageName.rules,
      path: (0, _link_to.getRuleDetailsUrl)(migrationRule.elastic_rule.id),
      "data-test-subj": "viewRule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 7
      }
    }, i18n.ACTIONS_VIEW_LABEL);
  }

  // Installable
  if (migrationRule.translation_result === _constants.MigrationTranslationResult.FULL) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      disabled: disableActions,
      onClick: () => {
        installMigrationRule(migrationRule);
      },
      "data-test-subj": "installRule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, i18n.ACTIONS_INSTALL_LABEL);
  }

  // Partially translated or untranslated
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: disableActions,
    onClick: () => {
      openMigrationRuleDetails(migrationRule);
    },
    "data-test-subj": "editRule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, i18n.ACTIONS_EDIT_LABEL);
};
const createActionsColumn = ({
  disableActions,
  openMigrationRuleDetails,
  installMigrationRule
}) => {
  return {
    field: 'elastic_rule',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      title: i18n.COLUMN_ACTIONS,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.tableColumn.actionsTooltip",
        defaultMessage: "{title} {view} - go to rule installed in the Detection rule (SIEM) page. {lineBreak} {install} - add rule to your Detection rule (SEIM) without enabling. {lineBreak} {edit} - Open detail view when a rule has not been fully translated.",
        values: {
          lineBreak: /*#__PURE__*/_react.default.createElement("br", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 107,
              columnNumber: 26
            }
          }),
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 109,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 110,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 111,
              columnNumber: 21
            }
          }, i18n.COLUMN_ACTIONS), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 112,
              columnNumber: 21
            }
          }))),
          view: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 116,
              columnNumber: 21
            }
          }, i18n.ACTIONS_VIEW_LABEL),
          install: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 24
            }
          }, i18n.ACTIONS_INSTALL_LABEL),
          edit: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 118,
              columnNumber: 21
            }
          }, i18n.ACTIONS_EDIT_LABEL)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }),
    render: (_, rule) => {
      return /*#__PURE__*/_react.default.createElement(ActionName, {
        disableActions: disableActions,
        migrationRule: rule,
        openMigrationRuleDetails: openMigrationRuleDetails,
        installMigrationRule: installMigrationRule,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 9
        }
      });
    },
    width: '10%',
    align: 'center'
  };
};
exports.createActionsColumn = createActionsColumn;