"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = exports.initialState = {
  loading: false,
  error: null
};
const reducer = (state, action) => {
  switch (action.type) {
    case 'start':
      return {
        loading: true,
        error: null
      };
    case 'error':
      return {
        loading: false,
        error: action.error
      };
    case 'success':
      return {
        loading: false,
        error: null
      };
    default:
      return state;
  }
};
exports.reducer = reducer;