"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _casesComponents = require("@kbn/cases-components");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/cases_table/status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statuses = {
  [_casesComponents.CaseStatuses.open]: {
    color: 'success',
    label: i18n.STATUS_OPEN
  },
  [_casesComponents.CaseStatuses['in-progress']]: {
    color: 'primary',
    label: i18n.STATUS_IN_PROGRESS
  },
  [_casesComponents.CaseStatuses.closed]: {
    color: 'default',
    label: i18n.STATUS_CLOSED
  }
};
const StatusBadge = ({
  status
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: statuses[status].color,
    "data-test-subj": "case-status-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, statuses[status].label);
};
exports.StatusBadge = StatusBadge;
StatusBadge.displayName = 'StatusBadge';