"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointActionItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/fleet-plugin/public");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _hooks = require("../../../../hooks");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../common/routing");
var _hooks2 = require("./hooks");
var _selectors = require("../../store/selectors");
var _hooks3 = require("../../../../../common/lib/kibana/hooks");
var _validators = require("../../../../../common/utils/validators");
var _get_host_platform = require("../../../../../common/lib/endpoint/utils/get_host_platform");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/hooks/use_endpoint_action_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns a list (array) of actions for an individual endpoint
 * @param endpointInfo
 * @param options
 */
const useEndpointActionItems = (endpointInfo, options) => {
  const {
    getAppUrl
  } = (0, _hooks3.useAppUrl)();
  const allCurrentUrlParams = (0, _hooks2.useEndpointSelector)(_selectors.uiQueryParams);
  const showEndpointResponseActionsConsole = (0, _hooks.useWithShowResponder)();
  const {
    canAccessResponseConsole,
    canIsolateHost,
    canUnIsolateHost,
    canAccessEndpointActionsLogManagement,
    canReadFleetAgentPolicies,
    canWriteFleetAgents,
    canReadFleetAgents
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return (0, _react.useMemo)(() => {
    var _endpointInfo$policy_;
    if (!endpointInfo) {
      return [];
    }
    const endpointAgentPolicyId = (_endpointInfo$policy_ = endpointInfo.policy_info) === null || _endpointInfo$policy_ === void 0 ? void 0 : _endpointInfo$policy_.agent.applied.id;
    const endpointMetadata = endpointInfo.metadata;
    const isIsolated = (0, _validators.isEndpointHostIsolated)(endpointMetadata);
    const endpointId = endpointMetadata.agent.id;
    const endpointHostName = endpointMetadata.host.hostname.toLowerCase();
    const fleetAgentId = endpointMetadata.elastic.agent.id;
    const {
      show,
      selected_endpoint: _selectedEndpoint,
      ...currentUrlParams
    } = allCurrentUrlParams;
    const endpointActionsPath = (0, _routing.getEndpointDetailsPath)({
      name: 'endpointActivityLog',
      ...currentUrlParams,
      selected_endpoint: endpointId
    });
    const endpointIsolatePath = (0, _routing.getEndpointDetailsPath)({
      name: 'endpointIsolate',
      ...currentUrlParams,
      selected_endpoint: endpointId
    });
    const endpointUnIsolatePath = (0, _routing.getEndpointDetailsPath)({
      name: 'endpointUnIsolate',
      ...currentUrlParams,
      selected_endpoint: endpointId
    });
    const isolationActions = [];
    if (isIsolated && canUnIsolateHost) {
      // Un-isolate is available to users regardless of license level if they have unisolate permissions
      isolationActions.push({
        'data-test-subj': 'unIsolateLink',
        icon: 'lockOpen',
        key: 'unIsolateHost',
        navigateAppId: _constants.APP_UI_ID,
        navigateOptions: {
          path: endpointUnIsolatePath
        },
        href: getAppUrl({
          path: endpointUnIsolatePath
        }),
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.unIsolateHost",
          defaultMessage: "Release host",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 11
          }
        })
      });
    } else if (canIsolateHost) {
      // For Platinum++ licenses, users also have ability to isolate
      isolationActions.push({
        'data-test-subj': 'isolateLink',
        icon: 'lock',
        key: 'isolateHost',
        navigateAppId: _constants.APP_UI_ID,
        navigateOptions: {
          path: endpointIsolatePath
        },
        href: getAppUrl({
          path: endpointIsolatePath
        }),
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.isolateHost",
          defaultMessage: "Isolate host",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 11
          }
        })
      });
    }
    return [...isolationActions, ...(canAccessResponseConsole ? [{
      'data-test-subj': 'console',
      icon: 'console',
      key: 'consoleLink',
      onClick: ev => {
        var _ref;
        ev.preventDefault();
        showEndpointResponseActionsConsole({
          agentId: endpointMetadata.agent.id,
          agentType: 'endpoint',
          capabilities: (_ref = endpointMetadata.Endpoint.capabilities) !== null && _ref !== void 0 ? _ref : [],
          hostName: endpointMetadata.host.name,
          platform: (0, _get_host_platform.getHostPlatform)(endpointMetadata)
        });
      },
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.console",
        defaultMessage: "Respond",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 17
        }
      })
    }] : []), ...(options !== null && options !== void 0 && options.isEndpointList && canAccessEndpointActionsLogManagement ? [{
      'data-test-subj': 'actionsLink',
      icon: 'logoSecurity',
      key: 'actionsLogLink',
      navigateAppId: _constants.APP_UI_ID,
      navigateOptions: {
        path: endpointActionsPath
      },
      href: getAppUrl({
        path: endpointActionsPath
      }),
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.responseActionsHistory",
        defaultMessage: "View response actions history",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 17
        }
      })
    }] : []), {
      'data-test-subj': 'hostLink',
      icon: 'logoSecurity',
      key: 'hostDetailsLink',
      navigateAppId: _constants.APP_UI_ID,
      navigateOptions: {
        path: `/hosts/${endpointHostName}`
      },
      href: getAppUrl({
        path: `/hosts/${endpointHostName}`
      }),
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.hostDetails",
        defaultMessage: "View host details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 11
        }
      })
    }, ...(canReadFleetAgentPolicies ? [{
      icon: 'gear',
      key: 'agentConfigLink',
      'data-test-subj': 'agentPolicyLink',
      navigateAppId: 'fleet',
      ...(endpointAgentPolicyId ? {
        navigateOptions: {
          path: `${_public.pagePathGetters.policy_details({
            policyId: endpointAgentPolicyId
          })[1]}`
        },
        href: `${getAppUrl({
          appId: 'fleet'
        })}${_public.pagePathGetters.policy_details({
          policyId: endpointAgentPolicyId
        })[1]}`
      } : {}),
      disabled: endpointAgentPolicyId === undefined,
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.agentPolicy",
        defaultMessage: "View agent policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 17
        }
      })
    }] : []), ...(canReadFleetAgents ? [{
      icon: 'gear',
      key: 'agentDetailsLink',
      'data-test-subj': 'agentDetailsLink',
      navigateAppId: 'fleet',
      navigateOptions: {
        path: `${_public.pagePathGetters.agent_details({
          agentId: fleetAgentId
        })[1]}`
      },
      href: `${getAppUrl({
        appId: 'fleet'
      })}${_public.pagePathGetters.agent_details({
        agentId: fleetAgentId
      })[1]}`,
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.agentDetails",
        defaultMessage: "View agent details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 17
        }
      })
    }] : []), ...(canWriteFleetAgents ? [{
      icon: 'gear',
      key: 'agentPolicyReassignLink',
      'data-test-subj': 'agentPolicyReassignLink',
      navigateAppId: 'fleet',
      navigateOptions: {
        path: `${_public.pagePathGetters.agent_details({
          agentId: fleetAgentId
        })[1]}?openReassignFlyout=true`,
        state: {
          onDoneNavigateTo: [_constants.APP_UI_ID, {
            path: (0, _routing.getEndpointListPath)({
              name: 'endpointList'
            })
          }]
        }
      },
      href: `${getAppUrl({
        appId: 'fleet'
      })}${_public.pagePathGetters.agent_details({
        agentId: fleetAgentId
      })[1]}?openReassignFlyout=true`,
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.actions.agentPolicyReassign",
        defaultMessage: "Reassign agent policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 17
        }
      })
    }] : [])];
  }, [allCurrentUrlParams, canAccessResponseConsole, canAccessEndpointActionsLogManagement, endpointInfo, getAppUrl, showEndpointResponseActionsConsole, options === null || options === void 0 ? void 0 : options.isEndpointList, canIsolateHost, canUnIsolateHost, canReadFleetAgentPolicies, canReadFleetAgents, canWriteFleetAgents]);
};
exports.useEndpointActionItems = useEndpointActionItems;