"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RunscriptOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _empty_value = require("../../../common/components/empty_value");
var _runscript_action_no_output = require("./runscript_action_no_output");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/runscript_action_result/runscript_action_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();
const ACCORDION_BUTTON_TEXT = Object.freeze({
  output: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionRunscriptAccordion.outputButtonTextRegular', {
      defaultMessage: 'Runscript output'
    })
  },
  error: {
    regular: _i18n.i18n.translate('xpack.securitySolution.responseActionRunscriptAccordion.errorButtonTextRegular', {
      defaultMessage: 'Runscript error'
    })
  }
});
const StyledEuiText = (0, _common.euiStyled)(_eui.EuiText)`
  white-space: pre-wrap;
  line-break: anywhere;
`;
const RunscriptOutputAccordion = /*#__PURE__*/(0, _react.memo)(({
  content = emptyValue,
  initialIsOpen = false,
  textSize = 'xs',
  type,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'executeActionOutputAccordions',
    suffix: type
  });
  const accordionButtonContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": getTestId('title'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, ACCORDION_BUTTON_TEXT[type].regular), [getTestId, textSize, type]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    initialIsOpen: initialIsOpen,
    buttonContent: accordionButtonContent,
    paddingSize: "s",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, typeof content === 'string' ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 42
    }
  }, content) : content));
});
RunscriptOutputAccordion.displayName = 'RunscriptOutputAccordion';
const RunscriptOutput = exports.RunscriptOutput = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId,
  'data-test-subj': dataTestSubj,
  textSize = 'xs'
}) => {
  const outputContent = (0, _react.useMemo)(() => action.outputs && action.outputs[agentId] && action.outputs[agentId].content, [action.outputs, agentId]);
  if (!outputContent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_runscript_action_no_output.RunscriptActionNoOutput, {
      textSize: textSize,
      "data-test-subj": `${dataTestSubj}-no-output`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }));
  }
  const {
    code,
    stderr,
    stdout
  } = outputContent;
  const isFileTooLargeError = Number(code) === 413;
  if (isFileTooLargeError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: textSize,
      "data-test-subj": `${dataTestSubj}-file-too-large`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.runScriptAction.outputFileTooLargeMessage', {
      defaultMessage: 'The output is too large to be displayed. Please download the output file to view the results.'
    })));
  }
  const hasErrorOutput = stderr && stderr.length > 0;
  const hasStdOutput = stdout && stdout.length > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, hasErrorOutput && /*#__PURE__*/_react.default.createElement(RunscriptOutputAccordion, {
    content: hasErrorOutput ? stderr : undefined,
    "data-test-subj": `${dataTestSubj}-stderr`,
    initialIsOpen: true,
    textSize: textSize,
    type: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }), hasStdOutput && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasErrorOutput && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 34
    }
  }), /*#__PURE__*/_react.default.createElement(RunscriptOutputAccordion, {
    content: hasStdOutput ? stdout : undefined,
    "data-test-subj": `${dataTestSubj}-stdout`,
    initialIsOpen: true,
    textSize: textSize,
    type: "output",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }))));
});
RunscriptOutput.displayName = 'RunscriptOutput';