"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryDumpResponseActionOutputResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18nReact = require("@kbn/i18n-react");
var _key_value_display = require("../key_value_display");
var _translations = require("../../common/translations");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _endpoint_action_failure_message = require("../endpoint_action_failure_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/memory_dump_response_action_output_result/memory_dump_response_action_output_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MemoryDumpResponseActionOutputResult = exports.MemoryDumpResponseActionOutputResult = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId: _agentId,
  'data-test-subj': dataTestSubj,
  textSize = 's'
}) => {
  var _action$outputs;
  const agentId = _agentId || action.agents[0];
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const agentActionState = action.agentState[agentId];
  const agentActionResult = (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : _action$outputs[agentId];
  return (0, _react.useMemo)(() => {
    if (!action.agents.includes(agentId)) {
      window.console.error(`MemoryDumpResponseActionOutputResult called with agentId [${agentId}] not in action.agents`);
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": testId(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 16
        }
      });
    }
    let result;
    if (!agentActionState.isCompleted) {
      result = /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": testId('pending'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }, _translations.RESPONSE_ACTION_STATUS.pendingMessage);
    } else if (!agentActionState.wasSuccessful) {
      result = /*#__PURE__*/_react.default.createElement(_endpoint_action_failure_message.EndpointActionFailureMessage, {
        action: action,
        "data-test-subj": testId('failure'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      });
    } else {
      var _agentActionResult$co, _agentActionResult$co2;
      result = /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": testId('success'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 11
        }
      }, agentActionResult !== null && agentActionResult !== void 0 && agentActionResult.content ? /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpointResponseActions.memoryDumpAction.successTitle",
        defaultMessage: "Memory dump file was created on host:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 19
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
        name: _translations.CONSOLE_COMMANDS.memoryDump.resultFileLabel,
        value: agentActionResult.content.path,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
        name: _translations.CONSOLE_COMMANDS.memoryDump.resultFileSizeLabel,
        value: (0, _numeral.default)((_agentActionResult$co = agentActionResult.content.file_size) !== null && _agentActionResult$co !== void 0 ? _agentActionResult$co : 0).format('0.00b'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
        name: _translations.CONSOLE_COMMANDS.memoryDump.resultRemainingFreeDiskSpaceLabel,
        value: (0, _numeral.default)((_agentActionResult$co2 = agentActionResult.content.disk_free_space) !== null && _agentActionResult$co2 !== void 0 ? _agentActionResult$co2 : 0).format('0.00b'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 21
        }
      })))) : /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": testId('agentResultMissing'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 15
        }
      }, _translations.CONSOLE_COMMANDS.memoryDump.agentResultMissing));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": testId(),
      size: textSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }, result);
  }, [action, agentActionResult === null || agentActionResult === void 0 ? void 0 : agentActionResult.content, agentActionState === null || agentActionState === void 0 ? void 0 : agentActionState.isCompleted, agentActionState === null || agentActionState === void 0 ? void 0 : agentActionState.wasSuccessful, agentId, testId, textSize]);
});
MemoryDumpResponseActionOutputResult.displayName = 'MemoryDumpResponseActionOutputResult';